/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classylog;

import au.com.cybersearch2.classylog.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLogger
implements Log {
    private Logger logger;
    private String name;

    protected JavaLogger(String name) {
        this.name = name;
        this.logger = Logger.getLogger(name);
    }

    public static JavaLogger getLogger(String name) {
        return new JavaLogger(name);
    }

    @Override
    public void verbose(String tag, String msg) {
        this.logger(tag).logp(Level.FINEST, tag, null, msg);
    }

    @Override
    public void verbose(String tag, String msg, Throwable tr) {
        this.logger(tag).logp(Level.FINEST, tag, null, msg, tr);
    }

    @Override
    public void debug(String tag, String msg) {
        this.logger(tag).logp(Level.FINE, tag, null, msg);
    }

    @Override
    public void debug(String tag, String msg, Throwable tr) {
        this.logger(tag).logp(Level.FINE, tag, null, msg, tr);
    }

    @Override
    public void info(String tag, String msg) {
        this.logger(tag).logp(Level.INFO, tag, null, msg);
    }

    @Override
    public void info(String tag, String msg, Throwable tr) {
        this.logger(tag).logp(Level.INFO, tag, null, msg, tr);
    }

    @Override
    public void warn(String tag, String msg) {
        this.logger(tag).logp(Level.WARNING, tag, null, msg);
    }

    @Override
    public void warn(String tag, String msg, Throwable tr) {
        this.logger(tag).logp(Level.WARNING, tag, null, msg, tr);
    }

    @Override
    public void error(String tag, String msg) {
        this.logger(tag).logp(Level.SEVERE, tag, null, msg);
    }

    @Override
    public void error(String tag, String msg, Throwable tr) {
        this.logger(tag).logp(Level.SEVERE, tag, null, msg, tr);
    }

    @Override
    public boolean isLoggable(String tag, Level level) {
        return this.logger(tag).isLoggable(level);
    }

    @Override
    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    protected Logger logger(String tag) {
        if (this.name.equals(tag) || tag == null || tag.length() == 0) {
            return this.logger;
        }
        return Logger.getLogger(tag);
    }
}

