/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classybean;

import au.com.cybersearch2.classybean.BeanException;
import com.googlecode.openbeans.BeanInfo;
import com.googlecode.openbeans.IntrospectionException;
import com.googlecode.openbeans.Introspector;
import com.googlecode.openbeans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Set;

public class BeanUtil {
    public static final Object[] NO_ARGS = new Object[0];

    public static Object invoke(Method method, Object receiver, Object ... args) throws BeanException {
        try {
            return method.invoke(receiver, args);
        }
        catch (IllegalArgumentException e) {
            throw new BeanException("Invoke failed for method " + method.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new BeanException("Invoke failed for method " + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new BeanException("Invoke failed for method " + method.getName(), e.getCause() == null ? e : e.getCause());
        }
    }

    public static BeanInfo getBeanInfo(Object bean) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(bean.getClass());
        }
        catch (IntrospectionException e) {
            throw new BeanException("Bean introspection failed for class " + bean.getClass().getName(), e);
        }
        return info;
    }

    public static Set<DataPair> getDataPairSet(Object bean) {
        BeanInfo info = BeanUtil.getBeanInfo(bean);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        HashSet<DataPair> result = new HashSet<DataPair>(descriptors.length * 2);
        for (PropertyDescriptor property : descriptors) {
            Method method = property.getReadMethod();
            if (method == null) continue;
            result.add(new DataPair(property.getName(), BeanUtil.invoke(method, bean, NO_ARGS)));
        }
        return result;
    }

    public static Object newClassInstance(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Parameter className is null");
        }
        try {
            Class<?> newClass = Class.forName(className);
            Object newInstance = newClass.newInstance();
            return newInstance;
        }
        catch (ClassNotFoundException e) {
            throw new BeanException("Class " + className + " not found", e);
        }
        catch (InstantiationException e) {
            throw new BeanException("Failed to instantiate class " + className, e.getCause() == null ? e : e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new BeanException("Security prevented creation of class " + className, e);
        }
    }

    public static class DataPair
    extends AbstractMap.SimpleImmutableEntry<String, Object> {
        private static final long serialVersionUID = 6959237568599112142L;

        public DataPair(String key, Object value) {
            super(key, value);
        }
    }
}

