/*
 * Decompiled with CFR 0.152.
 */
package au.com.cybersearch2.classybean;

import au.com.cybersearch2.classybean.BeanMap;
import au.com.cybersearch2.classyfy.data.alfresco.RecordCategory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class BeanMapTest {
    Date created;
    Date modified;

    @Before
    public void setUp() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS", new Locale("en", "AU"));
        this.created = sdf.parse("2014-02-05 18:45:46.000000");
        this.modified = sdf.parse("2014-02-12 11:55:23.000000");
    }

    @Test
    public void test_BeanMap() throws Exception {
        RecordCategory recordCategory = new RecordCategory();
        this.populateRecordCategory(recordCategory);
        BeanMap beanMap = new BeanMap((Object)recordCategory);
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"created")).isTrue();
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"modified")).isTrue();
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"creator")).isTrue();
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"modifier")).isTrue();
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"description")).isTrue();
        Assertions.assertThat((boolean)beanMap.containsKey((Object)"identifier")).isTrue();
        Assertions.assertThat((Object)beanMap.get((Object)"created")).isEqualTo((Object)this.created);
        Assertions.assertThat((Object)beanMap.get((Object)"modified")).isEqualTo((Object)this.modified);
        Assertions.assertThat((Object)beanMap.get((Object)"creator")).isEqualTo((Object)"admin");
        Assertions.assertThat((Object)beanMap.get((Object)"modifier")).isEqualTo((Object)"prole");
        Assertions.assertThat((Object)beanMap.get((Object)"description")).isEqualTo((Object)"Information Technology");
        Assertions.assertThat((Object)beanMap.get((Object)"identifier")).isEqualTo((Object)"2014-1391586274589");
        Set entrySet = beanMap.entrySet();
        int size = entrySet.size();
        Assertions.assertThat((int)size).isGreaterThan(6);
        try {
            entrySet.remove(entrySet.iterator().next());
            Assertions.failBecauseExceptionWasNotThrown(UnsupportedOperationException.class);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        HashMap shadowMap = new HashMap();
        for (Map.Entry entry : entrySet) {
            shadowMap.put(entry.getKey(), entry.getValue());
        }
        Assertions.assertThat((boolean)shadowMap.containsKey("created")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("modified")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("creator")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("modifier")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("description")).isTrue();
        Assertions.assertThat((boolean)shadowMap.containsKey("identifier")).isTrue();
        Assertions.assertThat(shadowMap.get("created")).isEqualTo((Object)this.created);
        Assertions.assertThat(shadowMap.get("modified")).isEqualTo((Object)this.modified);
        Assertions.assertThat(shadowMap.get("creator")).isEqualTo((Object)"admin");
        Assertions.assertThat(shadowMap.get("modifier")).isEqualTo((Object)"prole");
        Assertions.assertThat(shadowMap.get("description")).isEqualTo((Object)"Information Technology");
        Assertions.assertThat(shadowMap.get("identifier")).isEqualTo((Object)"2014-1391586274589");
    }

    protected void populateRecordCategory(RecordCategory recordCategory) {
        recordCategory.setCreated(this.created);
        recordCategory.setModified(this.modified);
        recordCategory.setCreator("admin");
        recordCategory.setModifier("prole");
        recordCategory.setDescription("Information Technology");
        recordCategory.setIdentifier("2014-1391586274589");
    }
}

