/*
 * Copyright 2013 Coherent Software Australia Pty Ltd (http://www.coherentsoftware.com.au)
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package au.com.coherentsoftware.gradle

import au.com.coherentsoftware.gradle.database.task.DbInit
import au.com.coherentsoftware.gradle.database.task.DbReset
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Gradle Plugin to clean and/or initialise a database from a sql file.
 *
 * <strong>Currently specific to MySQL.</strong> See the Overview for example use.
 *
 */
class DatabasePlugin implements Plugin<Project> {
    // * This approach may not work in multi-project build. See GRADLE-2363

    void apply(Project project) {
        project.extensions.create('database', DatabasePluginExtension)
        project.tasks.withType(DbInit) { task ->
            project.logger.info("Configuring DbInit task ${task}")
            configureTaskDefaults(task, project)
        }
        project.tasks.withType(DbReset) { task ->
            project.logger.info("Configuring DbReset task ${task}")
            configureTaskDefaults(task, project)
        }
    }

    private configureTaskDefaults(task, Project project) {
        task.with {
            username = project.database.username
            password = project.database.password
            host = project.database.host ?: 'localhost'
            port = project.database.port ?: '3306'
            driver = project.database.driver ?: 'com.mysql.jdbc.Driver'
            group = 'Database'
        }
    }
}
