/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.util;

import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.resource.ResourcePointer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineReader {
    private final BufferedReader reader;
    private ResourcePointer ptr;
    private char[] line;
    private int lineIndex;

    public LineReader(ResourceName resourceName, Reader reader) {
        this(new ResourcePointer(resourceName), reader);
    }

    public LineReader(ResourcePointer ptr, Reader reader) {
        this.ptr = ptr;
        this.reader = new BufferedReader(reader);
        this.line = null;
        this.lineIndex = ptr.getLineNo();
    }

    public int nextChar() throws IOException {
        int ch;
        if (this.line == null) {
            String str = this.reader.readLine();
            if (str == null) {
                return -1;
            }
            this.line = str.toCharArray();
            this.lineIndex = 0;
            this.ptr = this.ptr.nextLine(str);
        }
        if (this.lineIndex >= this.line.length) {
            String str = this.reader.readLine();
            if (str == null) {
                return -1;
            }
            ch = 10;
            this.line = str.toCharArray();
            this.lineIndex = 0;
            this.ptr = this.ptr.nextLine(str);
        } else {
            ch = this.line[this.lineIndex++];
        }
        this.ptr = this.ptr.nextCol();
        return ch;
    }

    public ResourcePointer getPointer() {
        return this.ptr;
    }
}

