/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tmpl.parse;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.resource.ResourcePointer;
import au.com.codeka.carrot.tmpl.parse.Token;
import au.com.codeka.carrot.tmpl.parse.TokenFactory;
import au.com.codeka.carrot.tmpl.parse.TokenType;
import au.com.codeka.carrot.util.LineReader;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;

public class Tokenizer {
    private final LineReader ins;
    private final TokenFactory tokenFactory;
    private char[] lookahead;

    public Tokenizer(LineReader ins) {
        this(ins, null);
    }

    public Tokenizer(LineReader ins, @Nullable TokenFactory tokenFactory) {
        this.ins = ins;
        this.tokenFactory = tokenFactory == null ? new DefaultTokenFactory() : tokenFactory;
    }

    @Nullable
    public Token getNextToken() throws CarrotException {
        TokenType tokenType = TokenType.UNKNOWN;
        StringBuilder content = new StringBuilder();
        int i;
        block9: while ((i = this.getNextChar()) >= 0) {
            char ch = (char)i;
            switch (ch) {
                case '{': {
                    i = this.getNextChar();
                    if (i < 0) {
                        return this.tokenFactory.create(tokenType, content);
                    }
                    switch (i) {
                        case 37: {
                            if (tokenType == TokenType.UNKNOWN) {
                                tokenType = TokenType.TAG;
                                continue block9;
                            }
                            if (tokenType == TokenType.FIXED) {
                                this.lookahead = new char[]{'{', '%'};
                                return this.tokenFactory.create(tokenType, content);
                            }
                            throw new CarrotException("Unexpected '{%'", this.ins.getPointer());
                        }
                        case 123: {
                            if (tokenType == TokenType.UNKNOWN) {
                                tokenType = TokenType.ECHO;
                                continue block9;
                            }
                            if (tokenType == TokenType.FIXED) {
                                this.lookahead = new char[]{'{', '{'};
                                return this.tokenFactory.create(tokenType, content);
                            }
                            throw new CarrotException("Unexpected '{{", this.ins.getPointer());
                        }
                        case 35: {
                            if (tokenType == TokenType.UNKNOWN) {
                                tokenType = TokenType.COMMENT;
                                continue block9;
                            }
                            if (tokenType == TokenType.FIXED) {
                                this.lookahead = new char[]{'{', '#'};
                                return this.tokenFactory.create(tokenType, content);
                            }
                            throw new CarrotException("Unexpected '{{", this.ins.getPointer());
                        }
                    }
                    if (tokenType == TokenType.UNKNOWN) {
                        tokenType = TokenType.FIXED;
                    }
                    content.append(ch);
                    if (i == 92) continue block9;
                    content.append((char)i);
                    continue block9;
                }
                case '#': 
                case '%': 
                case '}': {
                    i = this.getNextChar();
                    if (i < 0) {
                        return this.tokenFactory.create(tokenType, content);
                    }
                    if ((char)i == '}') {
                        if (tokenType == TokenType.ECHO && ch != '}') {
                            throw new CarrotException("Expected '}}'", this.ins.getPointer());
                        }
                        if (tokenType == TokenType.TAG && ch != '%') {
                            throw new CarrotException("Expected '%}'", this.ins.getPointer());
                        }
                        if (tokenType == TokenType.COMMENT && ch != '#') {
                            throw new CarrotException("Expected '#}'", this.ins.getPointer());
                        }
                        if (tokenType == TokenType.FIXED) {
                            content.append(ch);
                            content.append((char)i);
                            continue block9;
                        }
                        return this.tokenFactory.create(tokenType, content);
                    }
                    content.append(ch);
                    content.append((char)i);
                    continue block9;
                }
            }
            if (tokenType == TokenType.UNKNOWN) {
                tokenType = TokenType.FIXED;
            }
            content.append(ch);
        }
        return this.tokenFactory.create(tokenType, content);
    }

    public ResourcePointer getPointer() {
        return this.ins.getPointer();
    }

    private int getNextChar() throws CarrotException {
        if (this.lookahead != null) {
            char ch = this.lookahead[0];
            this.lookahead = (char[])(this.lookahead.length == 1 ? null : Arrays.copyOfRange(this.lookahead, 1, this.lookahead.length));
            return ch;
        }
        try {
            return this.ins.nextChar();
        }
        catch (IOException e) {
            throw new CarrotException(e, this.ins.getPointer());
        }
    }

    private class DefaultTokenFactory
    implements TokenFactory {
        private DefaultTokenFactory() {
        }

        @Override
        public Token create(TokenType type, StringBuilder content) {
            switch (type) {
                case UNKNOWN: {
                    return null;
                }
            }
            return Token.create(type, content.toString(), Tokenizer.this.ins.getPointer());
        }
    }
}

