/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.Bindings;
import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.bindings.Composite;
import au.com.codeka.carrot.bindings.IterableExpansionBindings;
import au.com.codeka.carrot.bindings.LoopVarBindings;
import au.com.codeka.carrot.bindings.SingletonBindings;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.tag.ElseTag;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TagNode;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class ForTag
extends Tag {
    private List<Identifier> loopIdentifiers;
    private Term loopExpression;

    @Override
    public boolean isBlockTag() {
        return true;
    }

    @Override
    public boolean canChain(Tag nextTag) {
        return nextTag instanceof ElseTag;
    }

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        this.loopIdentifiers = stmtParser.parseIdentifierList();
        stmtParser.parseToken(TokenType.IN);
        this.loopExpression = stmtParser.parseTerm();
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        Node nextNode;
        List<Object> objects = ValueHelper.iterate(this.loopExpression.evaluate(engine.getConfig(), scope));
        for (int i = 0; i < objects.size(); ++i) {
            Object current = objects.get(i);
            Bindings loopIdentifierBindings = this.loopIdentifiers.size() > 1 && current instanceof Iterable ? new IterableExpansionBindings(this.loopIdentifiers, (Iterable)current) : new SingletonBindings(this.loopIdentifiers.get(0).evaluate(), current);
            scope.push(new Composite(loopIdentifierBindings, new SingletonBindings("loop", new LoopVarBindings(objects.size(), i))));
            tagNode.renderChildren(engine, writer, scope);
            scope.pop();
        }
        if (objects.size() == 0 && (nextNode = tagNode.getNextNode()) != null) {
            nextNode.render(engine, writer, scope);
        }
    }
}

