/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TagNode;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nullable;

public class ElseTag
extends Tag {
    @Nullable
    private Term expr;

    @Override
    public boolean isBlockTag() {
        return true;
    }

    @Override
    public boolean canChain(Tag nextTag) {
        if (this.expr == null) {
            return false;
        }
        return nextTag instanceof ElseTag;
    }

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        Identifier identifier = stmtParser.maybeParseIdentifier();
        if (identifier != null) {
            if (!identifier.evaluate().equalsIgnoreCase("if")) {
                throw new CarrotException("Expected 'if' after 'else'.");
            }
            this.expr = stmtParser.parseTerm();
        }
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        if (this.expr == null || ValueHelper.isTrue(this.expr.evaluate(engine.getConfig(), scope))) {
            tagNode.renderChildren(engine, writer, scope);
        } else {
            Node nextNode = tagNode.getNextNode();
            if (nextNode != null) {
                nextNode.render(engine, writer, scope);
            }
        }
    }
}

