/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.values;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TermParser;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;

public final class StringTermParser
implements TermParser {
    private final TermParser delegate;

    public StringTermParser(TermParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public Term parse(Tokenizer tokenizer) throws CarrotException {
        if (!tokenizer.accept(TokenType.STRING_LITERAL)) {
            return this.delegate.parse(tokenizer);
        }
        return new StringTerm(tokenizer.expect(TokenType.STRING_LITERAL));
    }

    private static final class StringTerm
    implements Term {
        private final Token token;

        public StringTerm(Token token) {
            this.token = token;
        }

        @Override
        public Object evaluate(Configuration config, Scope scope) throws CarrotException {
            return this.token.getValue();
        }

        public String toString() {
            return "\"" + this.token.getValue().toString() + "\"";
        }
    }
}

