/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.values;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TermParser;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;

public final class NumberTermParser
implements TermParser {
    private final TermParser delegate;

    public NumberTermParser(TermParser delegate) {
        this.delegate = delegate;
    }

    @Override
    public Term parse(Tokenizer tokenizer) throws CarrotException {
        if (!tokenizer.accept(TokenType.NUMBER_LITERAL)) {
            return this.delegate.parse(tokenizer);
        }
        return new NumberTerm(tokenizer.expect(TokenType.NUMBER_LITERAL));
    }

    private static final class NumberTerm
    implements Term {
        private final Token token;

        public NumberTerm(Token token) {
            this.token = token;
        }

        @Override
        public Object evaluate(Configuration config, Scope scope) throws CarrotException {
            return ValueHelper.toNumber(this.token.getValue());
        }

        public String toString() {
            return this.token.getValue().toString();
        }
    }
}

