/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr.accessible;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.expr.EmptyTerm;
import au.com.codeka.carrot.expr.Term;
import au.com.codeka.carrot.expr.TermParser;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.expr.Tokenizer;
import au.com.codeka.carrot.expr.accessible.AccessOperator;
import au.com.codeka.carrot.expr.accessible.AccessTerm;
import au.com.codeka.carrot.expr.accessible.AccessibleTerm;
import au.com.codeka.carrot.expr.accessible.MethodTerm;
import au.com.codeka.carrot.expr.accessible.Unaccessible;
import au.com.codeka.carrot.expr.values.EmptyTermParser;
import au.com.codeka.carrot.expr.values.IdentifierTermParser;
import au.com.codeka.carrot.expr.values.Variable;

public final class AccessTermParser
implements TermParser {
    private final TermParser valueParser = new IdentifierTermParser(new EmptyTermParser());
    private final TermParser expressionTerm;
    private final TermParser identifierTerm;
    private final TermParser iterationTerm;

    public AccessTermParser(TermParser expressionTerm, TermParser identifierTerm, TermParser iterationTerm) {
        this.iterationTerm = iterationTerm;
        this.expressionTerm = expressionTerm;
        this.identifierTerm = identifierTerm;
    }

    @Override
    public Term parse(Tokenizer tokenizer) throws CarrotException {
        Term left = this.valueParser.parse(tokenizer);
        if (left instanceof EmptyTerm) {
            return left;
        }
        AccessibleTerm result = new Unaccessible(new Variable(left));
        while (tokenizer.accept(TokenType.DOT, TokenType.LSQUARE, TokenType.LPAREN)) {
            Token token = tokenizer.expect(TokenType.DOT, TokenType.LSQUARE, TokenType.LPAREN);
            if (token.getType() == TokenType.DOT) {
                result = new AccessTerm(result, new AccessOperator(), this.identifierTerm.parse(tokenizer), TokenType.DOT);
            }
            if (token.getType() == TokenType.LSQUARE) {
                result = new AccessTerm(result, new AccessOperator(), this.expressionTerm.parse(tokenizer), TokenType.LSQUARE);
            }
            if (token.getType() == TokenType.LPAREN) {
                result = new Unaccessible(new MethodTerm(result, this.iterationTerm.parse(tokenizer)));
            }
            if (token.getType().closingType() == null) continue;
            tokenizer.expect(token.getType().closingType());
        }
        return result;
    }
}

