/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.tag.BlockTag;
import au.com.codeka.carrot.tag.EchoTag;
import au.com.codeka.carrot.tag.ElseTag;
import au.com.codeka.carrot.tag.EndTag;
import au.com.codeka.carrot.tag.ExtendsTag;
import au.com.codeka.carrot.tag.ForTag;
import au.com.codeka.carrot.tag.IfTag;
import au.com.codeka.carrot.tag.IncludeTag;
import au.com.codeka.carrot.tag.SetTag;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.util.Log;
import java.util.ArrayList;

public class TagRegistry {
    private final Configuration config;
    private final ArrayList<Entry> entries;

    public static Builder newBuilder() {
        return new Builder();
    }

    private TagRegistry(Configuration config, ArrayList<Entry> entries) {
        this.config = config;
        this.entries = entries;
    }

    public Tag createTag(String tagName) {
        for (Entry entry : this.entries) {
            if (!entry.matcher.isMatch(tagName)) continue;
            try {
                return entry.tagClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Log.warning(this.config, "Error creating instance of tag '%s': %s", tagName, e);
            }
        }
        return null;
    }

    public static class Builder {
        private final ArrayList<Entry> entries = new ArrayList();

        public Builder() {
            this.add("echo", EchoTag.class);
            this.add("if", IfTag.class);
            this.add("for", ForTag.class);
            this.add("else", ElseTag.class);
            this.add("extends", ExtendsTag.class);
            this.add("block", BlockTag.class);
            this.add("set", SetTag.class);
            this.add("include", IncludeTag.class);
            this.add(new TagMatcher(){

                @Override
                public boolean isMatch(String tagName) {
                    return tagName.toLowerCase().startsWith("end");
                }
            }, EndTag.class);
        }

        public Builder add(String name, Class<? extends Tag> tagClass) {
            return this.add(new DefaultTagMatcher(name), tagClass);
        }

        public Builder add(TagMatcher tagMatcher, Class<? extends Tag> tagClass) {
            this.entries.add(new Entry(tagMatcher, tagClass));
            return this;
        }

        public TagRegistry build(Configuration config) {
            return new TagRegistry(config, this.entries);
        }
    }

    private static class DefaultTagMatcher
    implements TagMatcher {
        private final String tagName;

        public DefaultTagMatcher(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public boolean isMatch(String tagName) {
            return tagName.equalsIgnoreCase(this.tagName);
        }
    }

    private static class Entry {
        TagMatcher matcher;
        Class<? extends Tag> tagClass;

        public Entry(TagMatcher matcher, Class<? extends Tag> tagClass) {
            this.matcher = matcher;
            this.tagClass = tagClass;
        }
    }

    public static interface TagMatcher {
        public boolean isMatch(String var1);
    }
}

