/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tmpl.Node;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ParseCache {
    private final Configuration config;
    private final Map<ResourceName, WeakReference<CacheEntry>> cache;

    public ParseCache(Configuration config) {
        this.config = config;
        this.cache = new HashMap<ResourceName, WeakReference<CacheEntry>>();
    }

    public Node getNode(ResourceName resourceName) throws CarrotException {
        CacheEntry cacheEntry;
        WeakReference<CacheEntry> cacheEntryRef = this.cache.get(resourceName);
        if (cacheEntryRef != null && (cacheEntry = (CacheEntry)cacheEntryRef.get()) != null) {
            long modifiedTime = this.config.getResourceLocator().getModifiedTime(resourceName);
            if (modifiedTime != cacheEntry.modifiedTime) {
                this.cache.remove(resourceName);
                return null;
            }
            return cacheEntry.node;
        }
        return null;
    }

    public void addNode(ResourceName resourceName, Node node) throws CarrotException {
        long modifiedTime = this.config.getResourceLocator().getModifiedTime(resourceName);
        this.cache.put(resourceName, new WeakReference<CacheEntry>(new CacheEntry(node, modifiedTime)));
    }

    private static class CacheEntry {
        Node node;
        long modifiedTime;

        public CacheEntry(Node node, long modifiedTime) {
            this.node = node;
            this.modifiedTime = modifiedTime;
        }
    }
}

