/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.TagRegistry;
import au.com.codeka.carrot.resource.MemoryResourceLocator;
import au.com.codeka.carrot.resource.ResourceLocator;

public class Configuration {
    private final String encoding;
    private final ResourceLocator resourceLocator;
    private final TagRegistry tagRegistry;
    private final Logger logger;
    private final boolean autoEscape;

    private Configuration(String encoding, ResourceLocator.Builder resourceLocatorBuilder, TagRegistry.Builder tagRegistryBuilder, Logger logger, boolean autoEscape) {
        this.encoding = encoding;
        this.resourceLocator = resourceLocatorBuilder.build(this);
        this.tagRegistry = tagRegistryBuilder.build(this);
        this.logger = logger;
        this.autoEscape = autoEscape;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public boolean getAutoEscape() {
        return this.autoEscape;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static class Builder {
        private String encoding = "utf-8";
        private ResourceLocator.Builder resourceLocatorBuilder;
        private TagRegistry.Builder tagRegistryBuilder;
        private Logger logger;
        private boolean autoEscape = true;

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setResourceLocator(ResourceLocator.Builder resourceLocatorBuilder) {
            this.resourceLocatorBuilder = resourceLocatorBuilder;
            return this;
        }

        public Builder setTagRegistry(TagRegistry.Builder tagRegistryBuilder) {
            this.tagRegistryBuilder = tagRegistryBuilder;
            return this;
        }

        public Builder setAutoEscape(boolean value) {
            this.autoEscape = value;
            return this;
        }

        public Builder setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.encoding, this.resourceLocatorBuilder == null ? new MemoryResourceLocator.Builder() : this.resourceLocatorBuilder, this.tagRegistryBuilder == null ? new TagRegistry.Builder() : this.tagRegistryBuilder, this.logger, this.autoEscape);
        }
    }

    public static interface Logger {
        public static final int LEVEL_DEBUG = 1;
        public static final int LEVEL_INFO = 2;
        public static final int LEVEL_WARNING = 3;

        public void print(int var1, String var2);
    }
}

