/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tmpl.parse;

import au.com.codeka.carrot.resource.ResourcePointer;
import au.com.codeka.carrot.tmpl.parse.TokenType;
import java.util.Objects;
import javax.annotation.Nullable;

public class Token {
    private final TokenType type;
    private final String content;
    @Nullable
    private final ResourcePointer ptr;

    private Token(TokenType type, String content, ResourcePointer ptr) {
        this.type = type;
        this.content = content;
        this.ptr = ptr;
    }

    public TokenType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public static Token create(TokenType type, String content) {
        return new Token(type, content, null);
    }

    public static Token create(TokenType type, String content, ResourcePointer ptr) {
        return new Token(type, content, ptr);
    }

    public boolean equals(Object other) {
        if (other instanceof Token) {
            return ((Token)other).type == this.type && ((Token)other).content.equals(this.content);
        }
        return false;
    }

    public ResourcePointer getPointer() {
        return this.ptr;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.content});
    }

    public String toString() {
        return String.format("%s <%s>", new Object[]{this.type, this.content});
    }
}

