/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tmpl;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.expr.Tokenizer;
import au.com.codeka.carrot.resource.ResourcePointer;
import au.com.codeka.carrot.tag.EndTag;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.parse.Token;
import au.com.codeka.carrot.util.LineReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class TagNode
extends Node {
    private final ResourcePointer ptr;
    private final Tag tag;

    public TagNode(ResourcePointer ptr, Tag tag) {
        super(ptr, tag.isBlockTag());
        this.ptr = ptr;
        this.tag = tag;
    }

    public static TagNode createEcho(Token token, Configuration config) throws CarrotException {
        return TagNode.create("echo", token.getContent(), config, token.getPointer());
    }

    public static TagNode create(Token token, Configuration config) throws CarrotException {
        String tagName;
        String content = token.getContent().trim();
        int space = content.indexOf(32);
        if (space <= 0) {
            tagName = content;
            content = "";
        } else {
            tagName = content.substring(0, space);
            content = content.substring(space).trim();
        }
        return TagNode.create(tagName, content, config, token.getPointer());
    }

    private static TagNode create(String tagName, String content, Configuration config, ResourcePointer ptr) throws CarrotException {
        Tag tag = config.getTagRegistry().createTag(tagName);
        if (tag == null) {
            throw new CarrotException(String.format("Invalid tag '%s'", tagName), ptr);
        }
        try {
            StatementParser stmtParser = new StatementParser(new Tokenizer(new LineReader(ptr, (Reader)new StringReader(content))));
            tag.parseStatement(stmtParser);
        }
        catch (CarrotException e) {
            throw new CarrotException("Exception parsing statement for '" + tagName + "' [" + content + "]", e);
        }
        return new TagNode(ptr, tag);
    }

    @Override
    public boolean canChain(Node nextNode) {
        if (nextNode instanceof TagNode) {
            Tag nextTag = ((TagNode)nextNode).tag;
            return this.tag.canChain(nextTag);
        }
        return false;
    }

    public boolean isEndBlock() {
        return this.tag instanceof EndTag;
    }

    public Tag getTag() {
        return this.tag;
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, Scope scope) throws CarrotException, IOException {
        this.tag.render(engine, writer, this, scope);
    }
}

