/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.bindings.MapBindings;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.tag.ElseTag;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TagNode;
import java.io.IOException;
import java.io.Writer;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;

public class ForTag
extends Tag {
    private Identifier loopIdentifier;
    private Expression loopExpression;

    @Override
    public boolean isBlockTag() {
        return true;
    }

    @Override
    public boolean canChain(Tag nextTag) {
        return nextTag instanceof ElseTag;
    }

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        this.loopIdentifier = stmtParser.parseIdentifier();
        Identifier inIdentifier = stmtParser.parseIdentifier();
        if (!inIdentifier.evaluate().equalsIgnoreCase("in")) {
            throw new CarrotException("Expected 'in'.");
        }
        this.loopExpression = stmtParser.parseExpression();
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        Node nextNode;
        List<Object> objects = ValueHelper.iterate(this.loopExpression.evaluate(engine.getConfig(), scope));
        HashMap<String, Constable> loop = new HashMap<String, Constable>();
        for (int i = 0; i < objects.size(); ++i) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(this.loopIdentifier.evaluate(), objects.get(i));
            loop.put("index", Integer.valueOf(i));
            loop.put("revindex", Integer.valueOf(objects.size() - i - 1));
            loop.put("first", Boolean.valueOf(i == 0));
            loop.put("last", Boolean.valueOf(i == objects.size() - 1));
            loop.put("length", Integer.valueOf(objects.size()));
            context.put("loop", loop);
            scope.push(new MapBindings(context));
            tagNode.renderChildren(engine, writer, scope);
            scope.pop();
        }
        if (objects.size() == 0 && (nextNode = tagNode.getNextNode()) != null) {
            nextNode.render(engine, writer, scope);
        }
    }
}

