/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tag;

import au.com.codeka.carrot.CarrotEngine;
import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.bindings.SingletonBindings;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.StatementParser;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tag.BlockTag;
import au.com.codeka.carrot.tag.Tag;
import au.com.codeka.carrot.tmpl.Node;
import au.com.codeka.carrot.tmpl.TagNode;
import au.com.codeka.carrot.util.Log;
import au.com.codeka.carrot.util.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class ExtendsTag
extends Tag {
    private Expression skeletonNameExpr;

    @Override
    public boolean isBlockTag() {
        return true;
    }

    @Override
    public void parseStatement(StatementParser stmtParser) throws CarrotException {
        this.skeletonNameExpr = stmtParser.parseExpression();
    }

    @Override
    public void render(CarrotEngine engine, Writer writer, TagNode tagNode, Scope scope) throws CarrotException, IOException {
        String skeletonName = this.skeletonNameExpr.evaluate(engine.getConfig(), scope).toString();
        HashMap<String, TagNode> blockTags = new HashMap<String, TagNode>();
        Preconditions.checkNotNull(tagNode.getChildren());
        for (Node childNode : tagNode.getChildren()) {
            if (!(childNode instanceof TagNode)) {
                Log.warning(engine.getConfig(), "Unexpected node inside {%% extends %%}: %s", childNode);
                continue;
            }
            TagNode childTagNode = (TagNode)childNode;
            if (!(childTagNode.getTag() instanceof BlockTag)) {
                Log.warning(engine.getConfig(), "Unexpected tag instde {%% extends %%}: {%% %s %%}", childTagNode.getTag());
                continue;
            }
            BlockTag blockTag = (BlockTag)childTagNode.getTag();
            blockTags.put(blockTag.getBlockName(engine, scope), childTagNode);
        }
        ResourceName resourceName = engine.getConfig().getResourceLocater().findResource(null, skeletonName);
        scope.push(new SingletonBindings("__blocks", blockTags));
        engine.process(writer, resourceName, scope);
        scope.pop();
    }
}

