/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.expr.Expression;
import au.com.codeka.carrot.expr.Identifier;
import au.com.codeka.carrot.expr.TokenType;
import au.com.codeka.carrot.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class Function {
    private final Identifier funcName;
    private final ArrayList<Expression> args;

    private Function(Identifier funcName, ArrayList<Expression> args) {
        this.funcName = funcName;
        this.args = args;
    }

    public String toString() {
        String str = this.funcName.toString() + " " + (Object)((Object)TokenType.LPAREN) + " ";
        for (int i = 0; i < this.args.size(); ++i) {
            if (i > 0) {
                str = str + " " + (Object)((Object)TokenType.COMMA) + " ";
            }
            str = str + this.args.get(i).toString();
        }
        str = str + " " + (Object)((Object)TokenType.RPAREN);
        return str;
    }

    public Object evaluate(Object value, Configuration config, Scope scope) throws CarrotException {
        Class[] paramTypes = new Class[this.args.size()];
        Object[] paramValues = new Object[this.args.size()];
        for (int i = 0; i < this.args.size(); ++i) {
            Object arg = this.args.get(i).evaluate(config, scope);
            paramTypes[i] = arg.getClass();
            paramValues[i] = arg;
        }
        try {
            Method method = this.findMethod(config, value.getClass(), this.funcName.evaluate(), paramTypes, paramValues);
            method.setAccessible(true);
            return method.invoke(value, paramValues);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CarrotException(e);
        }
    }

    private Method findMethod(Configuration config, Class<?> cls, String name, Class<?>[] paramTypes, Object[] paramValues) throws CarrotException {
        ArrayList<String> candidates = new ArrayList<String>();
        for (Method method : cls.getMethods()) {
            int i;
            if (!method.getName().equalsIgnoreCase(name)) continue;
            if (method.getParameterCount() != paramTypes.length) {
                Log.debug(config, "Wrong number of arguments: %d: %s", paramTypes.length, method);
                candidates.add(method.toString());
                continue;
            }
            boolean allMatch = true;
            Class<?>[] methodParamTypes = method.getParameterTypes();
            for (i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].isAssignableFrom(paramTypes[i])) continue;
                Object convertedValue = Function.convertType(methodParamTypes[i], paramValues[i]);
                if (convertedValue != null) {
                    paramValues[i] = convertedValue;
                    continue;
                }
                Log.debug(config, "Param %d (%s) not assignable from %s: %s", i, methodParamTypes[i], paramTypes[i], method);
                candidates.add(method.toString());
                allMatch = false;
                break;
            }
            if (!allMatch) continue;
            for (i = 0; i < method.getParameterCount(); ++i) {
                paramValues[i] = Function.convertType(method.getParameterTypes()[i], paramValues[i]);
            }
            return method;
        }
        throw new CarrotException(String.format("No matching method '%s' found on class %s, candidates: [%s]", name, cls.getName(), String.join((CharSequence)",", candidates)));
    }

    @Nullable
    private static Object convertType(Class<?> outputType, Object value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        if (outputType.equals(value.getClass())) {
            return value;
        }
        if (outputType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if ((Byte.TYPE.equals(outputType) || Byte.class.equals(outputType)) && value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if ((Short.TYPE.equals(outputType) || Short.class.equals(outputType)) && value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if ((Integer.TYPE.equals(outputType) || Integer.class.equals(outputType)) && value instanceof Number) {
            return ((Number)value).intValue();
        }
        if ((Long.TYPE.equals(outputType) || Long.class.equals(outputType)) && value instanceof Number) {
            return ((Number)value).longValue();
        }
        if ((Float.TYPE.equals(outputType) || Float.class.equals(outputType)) && value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if ((Double.TYPE.equals(outputType) || Double.class.equals(outputType)) && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public static class Builder {
        private final Identifier funcName;
        private final ArrayList<Expression> args;

        public Builder(Identifier funcName) {
            this.funcName = funcName;
            this.args = new ArrayList();
        }

        public Builder addParam(Expression arg) {
            this.args.add(arg);
            return this;
        }

        public Function build() {
            return new Function(this.funcName, this.args);
        }
    }
}

