/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.resource;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.resource.ResourceLocater;
import au.com.codeka.carrot.resource.ResourceName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class FileResourceLocater
implements ResourceLocater {
    private final Configuration config;
    private final File baseFile;

    public FileResourceLocater(Configuration config, String basePath) {
        this.config = config;
        this.baseFile = new File(basePath);
    }

    @Override
    public ResourceName findResource(@Nullable ResourceName parent, String name) throws CarrotException {
        File file;
        Path path = Paths.get(name, new String[0]);
        if (path.getRoot() != null) {
            File file2 = new File(name);
            return new FileResourceName(null, file2.getName(), file2);
        }
        if (parent != null && (file = new File(((FileResourceName)parent).getFile(), name)).exists() && file.isFile()) {
            return new FileResourceName(parent, name, file);
        }
        file = new File(this.baseFile, name);
        if (file.exists() && file.isFile()) {
            return new FileResourceName(null, name, file);
        }
        throw new CarrotException(new FileNotFoundException("[parent = " + parent + "] [name = " + name + "] [base = " + this.baseFile + "]"));
    }

    @Override
    public ResourceName findResource(String name) throws CarrotException {
        return this.findResource(null, name);
    }

    @Override
    public long getModifiedTime(ResourceName resourceName) throws CarrotException {
        return ((FileResourceName)resourceName).getFile().lastModified();
    }

    @Override
    public Reader getReader(ResourceName resourceName) throws CarrotException {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(((FileResourceName)resourceName).getFile()), this.config.getEncoding());
        }
        catch (IOException e) {
            throw new CarrotException(e);
        }
    }

    private static class FileResourceName
    extends ResourceName {
        private final File file;

        public FileResourceName(@Nullable ResourceName parent, String name, File file) {
            super(parent, name);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public ResourceName getParent() {
            File parent = this.file.getParentFile();
            return new FileResourceName(null, parent.getName(), parent);
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof FileResourceName && ((FileResourceName)other).file.equals(this.file);
        }
    }
}

