/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.util.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Scope {
    private final Deque<Map<String, Object>> stack = new ArrayDeque<Map<String, Object>>();

    public Scope(Map<String, Object> globalBindings) {
        this.stack.add(globalBindings);
    }

    public void push(Map<String, Object> bindings) {
        this.stack.push(bindings);
    }

    public void pop() {
        this.stack.pop();
    }

    public Map<String, Object> peek() {
        return this.stack.peek();
    }

    @Nullable
    public Object resolve(@Nonnull String name) {
        Preconditions.checkNotNull(name);
        for (Map<String, Object> bindings : this.stack) {
            Object value = bindings.get(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

