/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.Factor;
import au.com.codeka.carrot.expr.Token;
import au.com.codeka.carrot.expr.TokenType;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class Term {
    private final ArrayList<PrefixedFactor> prefixedFactors;

    private Term(ArrayList<PrefixedFactor> prefixedFactors) {
        this.prefixedFactors = prefixedFactors;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PrefixedFactor prefixedFactor : this.prefixedFactors) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (prefixedFactor.prefix != null) {
                sb.append(prefixedFactor.prefix);
                sb.append(" ");
            }
            sb.append(prefixedFactor.factor);
        }
        return sb.toString();
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        Object value = this.prefixedFactors.get((int)0).factor.evaluate(config, scope);
        for (int i = 1; i < this.prefixedFactors.size(); ++i) {
            Number lhs = ValueHelper.toNumber(value);
            Number rhs = ValueHelper.toNumber(this.prefixedFactors.get((int)i).factor.evaluate(config, scope));
            Token prefix = this.prefixedFactors.get((int)i).prefix;
            if (prefix == null) {
                throw new CarrotException("Unexpected null prefix.");
            }
            value = prefix.getType() == TokenType.DIVIDE ? (Number)ValueHelper.divide(lhs, rhs) : (Number)ValueHelper.multiply(lhs, rhs);
        }
        return value;
    }

    private static class PrefixedFactor {
        @Nullable
        public Token prefix;
        public Factor factor;

        PrefixedFactor(@Nullable Token prefix, Factor factor) {
            this.prefix = prefix;
            this.factor = factor;
        }
    }

    public static class Builder {
        private final ArrayList<PrefixedFactor> factors = new ArrayList();

        public Builder(@Nullable Token prefix, Factor factor) {
            this.factors.add(new PrefixedFactor(prefix, factor));
        }

        public Builder addFactor(Token prefix, Factor factor) {
            this.factors.add(new PrefixedFactor(prefix, factor));
            return this;
        }

        public Term build() {
            return new Term(this.factors);
        }
    }
}

