/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.resource;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.resource.ResourceLocater;
import au.com.codeka.carrot.resource.ResourceName;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.annotation.Nullable;

public class MemoryResourceLocator
implements ResourceLocater {
    private final Map<String, String> resources;

    public MemoryResourceLocator(Map<String, String> resources) {
        this.resources = resources;
    }

    @Override
    public ResourceName findResource(@Nullable ResourceName parent, String name) throws CarrotException {
        if (parent != null) {
            // empty if block
        }
        return new MemoryResourceName(null, name);
    }

    @Override
    public ResourceName findResource(String name) throws CarrotException {
        return this.findResource(null, name);
    }

    @Override
    public long getModifiedTime(ResourceName resourceName) throws CarrotException {
        return 0L;
    }

    @Override
    public Reader getReader(ResourceName resourceName) throws CarrotException {
        String name = ((MemoryResourceName)resourceName).name;
        String resource = this.resources.get(name);
        if (resource == null) {
            throw new CarrotException(String.format("File not found: %s", name));
        }
        return new StringReader(this.resources.get(name));
    }

    private static class MemoryResourceName
    extends ResourceName {
        private final String name;

        public MemoryResourceName(@Nullable ResourceName parent, String name) {
            super(parent, name);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ResourceName getParent() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof MemoryResourceName && ((MemoryResourceName)other).name.equals(this.name);
        }
    }
}

