/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.AndCond;
import au.com.codeka.carrot.expr.TokenType;
import java.util.ArrayList;

public class NotCond {
    private final ArrayList<AndCond> andConds;

    private NotCond(ArrayList<AndCond> andConds) {
        this.andConds = andConds;
    }

    public String toString() {
        String str = this.andConds.get(0).toString();
        for (int i = 1; i < this.andConds.size(); ++i) {
            str = str + " " + (Object)((Object)TokenType.LOGICAL_AND) + " ";
            str = str + this.andConds.get(i).toString();
        }
        return str;
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        Object value = this.andConds.get(0).evaluate(config, scope);
        for (int i = 1; i < this.andConds.size(); ++i) {
            value = ValueHelper.isTrue(value) && ValueHelper.isTrue(this.andConds.get(i).evaluate(config, scope));
        }
        return value;
    }

    public static class Builder {
        private ArrayList<AndCond> andConds = new ArrayList();

        public Builder(AndCond andCond) {
            this.andConds.add(andCond);
        }

        public Builder addAndCond(AndCond andCond) {
            this.andConds.add(andCond);
            return this;
        }

        public NotCond build() {
            return new NotCond(this.andConds);
        }
    }
}

