/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.expr;

import au.com.codeka.carrot.CarrotException;
import au.com.codeka.carrot.Configuration;
import au.com.codeka.carrot.Scope;
import au.com.codeka.carrot.ValueHelper;
import au.com.codeka.carrot.expr.OrCond;
import au.com.codeka.carrot.expr.TokenType;
import java.util.ArrayList;

public class AndCond {
    private final ArrayList<OrCond> orConds;

    private AndCond(ArrayList<OrCond> orConds) {
        this.orConds = orConds;
    }

    public String toString() {
        String str = this.orConds.get(0).toString();
        for (int i = 1; i < this.orConds.size(); ++i) {
            str = str + " " + (Object)((Object)TokenType.LOGICAL_OR);
        }
        return str;
    }

    public Object evaluate(Configuration config, Scope scope) throws CarrotException {
        Object value = this.orConds.get(0).evaluate(config, scope);
        for (int i = 1; i < this.orConds.size(); ++i) {
            value = ValueHelper.isTrue(value) || ValueHelper.isTrue(this.orConds.get(i).evaluate(config, scope));
        }
        return value;
    }

    public static class Builder {
        private ArrayList<OrCond> orConds = new ArrayList();

        public Builder(OrCond orCond) {
            this.orConds.add(orCond);
        }

        public Builder addOrCond(OrCond orCond) {
            this.orConds.add(orCond);
            return this;
        }

        public AndCond build() {
            return new AndCond(this.orConds);
        }
    }
}

