/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot;

import au.com.codeka.carrot.CarrotException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValueHelper {
    public static boolean isTrue(Object value) throws CarrotException {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        throw new CarrotException("Value '" + value + "' cannot be converted to boolean.");
    }

    public static Number negate(Object value) throws CarrotException {
        if (value == null) {
            throw new CarrotException("Value is null");
        }
        Number num = ValueHelper.toNumber(value);
        if (num instanceof Integer) {
            return -((Integer)num).intValue();
        }
        if (num instanceof Long) {
            return -((Long)num).longValue();
        }
        if (num instanceof Float) {
            return Float.valueOf(-((Float)num).floatValue());
        }
        if (num instanceof Double) {
            return -((Double)num).doubleValue();
        }
        throw new CarrotException("Value '" + value + "' cannot be negated.");
    }

    public static Number toNumber(Object value) throws CarrotException {
        if (value == null) {
            throw new CarrotException("Value is null.");
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.contains(".")) {
                return Double.parseDouble(str);
            }
            return Long.parseLong(str);
        }
        throw new CarrotException("Cannot convert '" + value + "' to a number.");
    }

    public static Number add(Object lhs, Object rhs) throws CarrotException {
        if (lhs == null || rhs == null) {
            throw new CarrotException("Left hand side or right hand side is null.");
        }
        Number lhsNumber = ValueHelper.toNumber(lhs);
        Number rhsNumber = ValueHelper.toNumber(rhs);
        if (lhsNumber instanceof Double || rhsNumber instanceof Double) {
            return lhsNumber.doubleValue() + rhsNumber.doubleValue();
        }
        if (lhsNumber instanceof Float || rhsNumber instanceof Float) {
            return Float.valueOf(lhsNumber.floatValue() + rhsNumber.floatValue());
        }
        if (lhsNumber instanceof Long || rhsNumber instanceof Long) {
            return lhsNumber.longValue() + rhsNumber.longValue();
        }
        if (lhsNumber instanceof Integer || rhsNumber instanceof Integer) {
            return lhsNumber.longValue() + rhsNumber.longValue();
        }
        throw new CarrotException("Unknown number type '" + lhs + "' or '" + rhs + "'.");
    }

    public static Number divide(Object lhs, Object rhs) throws CarrotException {
        if (lhs == null || rhs == null) {
            throw new CarrotException("Left hand side or right hand side is null.");
        }
        Number lhsNumber = ValueHelper.toNumber(lhs);
        Number rhsNumber = ValueHelper.toNumber(rhs);
        if (lhsNumber instanceof Double || rhsNumber instanceof Double) {
            return lhsNumber.doubleValue() / rhsNumber.doubleValue();
        }
        if (lhsNumber instanceof Float || rhsNumber instanceof Float) {
            return Float.valueOf(lhsNumber.floatValue() / rhsNumber.floatValue());
        }
        if (lhsNumber instanceof Long || rhsNumber instanceof Long) {
            return lhsNumber.longValue() / rhsNumber.longValue();
        }
        if (lhsNumber instanceof Integer || rhsNumber instanceof Integer) {
            return lhsNumber.longValue() / rhsNumber.longValue();
        }
        throw new CarrotException("Unknown number type '" + lhs + "' or '" + rhs + "'.");
    }

    public static Number multiply(Object lhs, Object rhs) throws CarrotException {
        if (lhs == null || rhs == null) {
            throw new CarrotException("Left hand side or right hand side is null.");
        }
        Number lhsNumber = ValueHelper.toNumber(lhs);
        Number rhsNumber = ValueHelper.toNumber(rhs);
        if (lhsNumber instanceof Double || rhsNumber instanceof Double) {
            return lhsNumber.doubleValue() * rhsNumber.doubleValue();
        }
        if (lhsNumber instanceof Float || rhsNumber instanceof Float) {
            return Float.valueOf(lhsNumber.floatValue() * rhsNumber.floatValue());
        }
        if (lhsNumber instanceof Long || rhsNumber instanceof Long) {
            return lhsNumber.longValue() * rhsNumber.longValue();
        }
        if (lhsNumber instanceof Integer || rhsNumber instanceof Integer) {
            return lhsNumber.longValue() * rhsNumber.longValue();
        }
        throw new CarrotException("Unknown number type '" + lhs + "' or '" + rhs + "'.");
    }

    public static List<Object> iterate(Object iterable) throws CarrotException {
        if (iterable == null) {
            return new ArrayList<Object>();
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        if (iterable instanceof Collection) {
            return new ArrayList<Object>((Collection)iterable);
        }
        if (iterable.getClass().isArray()) {
            int length = Array.getLength(iterable);
            ArrayList<Object> objects = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                objects.add(Array.get(iterable, i));
            }
            return objects;
        }
        throw new CarrotException("Unable to iterate '" + iterable + "'");
    }
}

