/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.util;

import au.com.codeka.carrot.base.CarrotException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class VariableChain {
    static final String GET = "get";
    static final String IS = "is";
    private List<String> chain;
    private Object value;

    public VariableChain(List<String> chain, Object value) {
        this.chain = chain;
        this.value = value;
    }

    public Object resolve() throws CarrotException {
        for (String name : this.chain) {
            if (this.value == null) {
                return null;
            }
            this.value = this.resolveInternal(name);
        }
        return this.value;
    }

    private Object resolveInternal(String name) throws CarrotException {
        Class<?> clazz = this.value.getClass();
        try {
            Field field = clazz.getDeclaredField(name);
            return field.get(this.value);
        }
        catch (Exception e1) {
            Method mth1 = null;
            try {
                mth1 = clazz.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String uname = this.upperFirst(name);
                try {
                    mth1 = clazz.getDeclaredMethod(GET + uname, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        mth1 = clazz.getDeclaredMethod(IS + uname, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (mth1 != null) {
                try {
                    return mth1.invoke(this.value, new Object[0]);
                }
                catch (Exception e) {
                    throw new CarrotException("Could not resolve variable.", e);
                }
            }
            if (this.value instanceof Map) {
                Map map = (Map)this.value;
                try {
                    Long l = Long.parseLong(name);
                    if (map.containsKey(l)) {
                        return map.get(l);
                    }
                }
                catch (NumberFormatException l) {
                    // empty catch block
                }
                try {
                    Integer i = Integer.parseInt(name);
                    if (map.containsKey(i)) {
                        return map.get(i);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (map.containsKey(name)) {
                    return map.get(name);
                }
            }
            try {
                int index = Integer.parseInt(name);
                if (this.value.getClass().isArray()) {
                    return Array.get(this.value, index);
                }
                if (this.value instanceof List) {
                    return ((List)this.value).get(index);
                }
                if (this.value instanceof Collection) {
                    return ((Collection)this.value).toArray()[index];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private String upperFirst(String name) {
        char c = name.charAt(0);
        if (Character.isLowerCase(c)) {
            return String.valueOf(c).toUpperCase().concat(name.substring(1));
        }
        return name;
    }
}

