/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.util;

import java.util.ArrayList;
import java.util.Iterator;

public class HelperStringTokenizer
implements Iterator<String> {
    private char[] helpers;
    private int currPost = 0;
    private int tokenStart = 0;
    private int length = 0;
    private char lastChar = (char)32;
    private int lastStart = 0;
    private boolean useComma = false;
    private char quoteChar = '\u0000';
    private boolean inQuote = false;

    public HelperStringTokenizer(String tobeToken) {
        this.helpers = tobeToken.toCharArray();
        this.length = tobeToken.length();
    }

    public void splitComma(boolean onOrOff) {
        this.useComma = onOrOff;
    }

    @Override
    public boolean hasNext() {
        return this.length > this.currPost;
    }

    @Override
    public String next() {
        while (this.currPost < this.length) {
            String token = this.makeToken();
            this.lastChar = this.helpers[this.currPost - 1];
            if (token == null) continue;
            return token;
        }
        return null;
    }

    private String makeToken() {
        char c;
        if ((c = this.helpers[this.currPost++]) == '\"' | c == '\'') {
            if (this.inQuote) {
                if (this.quoteChar == c) {
                    this.inQuote = false;
                }
            } else {
                this.inQuote = true;
                this.quoteChar = c;
            }
        }
        if ((Character.isWhitespace(c) || this.useComma && c == ',') && !this.inQuote) {
            return this.newToken();
        }
        if (this.currPost == this.length) {
            return this.getEndToken();
        }
        return null;
    }

    private String getEndToken() {
        return String.copyValueOf(this.helpers, this.tokenStart, this.currPost - this.tokenStart);
    }

    private String newToken() {
        this.lastStart = this.tokenStart;
        this.tokenStart = this.currPost;
        if (Character.isWhitespace(this.lastChar) || this.useComma && this.lastChar == ',') {
            return null;
        }
        return String.copyValueOf(this.helpers, this.lastStart, this.currPost - this.lastStart - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String[] allTokens() {
        ArrayList<String> al = new ArrayList<String>();
        while (this.hasNext()) {
            al.add(this.next());
        }
        return al.toArray(new String[0]);
    }
}

