/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.lib.Tag;
import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.TagToken;
import au.com.codeka.carrot.tree.Node;
import java.io.IOException;
import java.io.Writer;

public class TagNode
extends Node {
    private static final long serialVersionUID = 2405693063353887509L;
    private TagToken master;
    String endName = null;

    public TagNode(Application app, TagToken token) throws ParseException {
        super(app);
        this.master = token;
        Tag tag = (Tag)app.getConfiguration().getTagLibrary().fetch(this.master.getTagName());
        this.endName = tag.getEndTagName();
    }

    @Override
    public void render(CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        interpreter.setLevel(this.level);
        Tag tag = (Tag)this.app.getConfiguration().getTagLibrary().fetch(this.master.getTagName());
        tag.interpreter(this.children(), this.master.getHelpers(), interpreter, writer);
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return this.master.getTagName();
    }

    @Override
    public Node clone() {
        try {
            TagNode clone = new TagNode(this.app, this.master);
            clone.children = this.children.clone(clone);
            return clone;
        }
        catch (ParseException e) {
            throw new InternalError();
        }
    }
}

