/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.tree.Node;
import java.io.Serializable;
import java.util.Iterator;

public class NodeList
implements Iterable<Node>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8672835620582591304L;
    Node head = null;
    Node tail = null;
    transient int size = 0;

    void add(Node node) {
        if (this.head == null) {
            this.head = this.tail = node;
        } else {
            this.tail.successor = node;
            node.predecessor = this.tail;
            this.tail = node;
        }
        ++this.size;
    }

    boolean append(Node add) {
        if (add == null) {
            return false;
        }
        if (this.head == null) {
            if (add.parent == null) {
                return false;
            }
            add.successor = null;
            add.predecessor = null;
            this.head = this.tail = add;
        } else {
            this.tail.successor = add;
            add.predecessor = this.tail;
            add.parent = this.tail.parent;
            add.successor = null;
            this.tail = add;
        }
        ++this.size;
        return true;
    }

    boolean forend(Node add) {
        if (add == null) {
            return false;
        }
        if (this.head == null) {
            if (add.parent == null) {
                return false;
            }
            add.successor = null;
            add.predecessor = null;
            this.head = this.tail = add;
        } else {
            this.head.predecessor = add;
            add.successor = this.head;
            add.parent = this.head.parent;
            add.predecessor = null;
            this.head = add;
        }
        ++this.size;
        return true;
    }

    boolean postend(Node to, Node add) {
        if (to == null || add == null || this.head == null || to.parent != this.head.parent || add.parent == to.parent) {
            return false;
        }
        add.parent = to.parent;
        add.predecessor = to;
        if (to == this.tail) {
            to.successor = add;
            add.successor = null;
            this.tail = add;
        } else {
            add.successor = to.successor;
            to.successor.predecessor = add;
            to.successor = add;
        }
        ++this.size;
        return true;
    }

    boolean preend(Node to, Node add) {
        if (to == null || add == null || this.head == null || to.parent != this.head.parent || add.parent == to.parent) {
            return false;
        }
        add.parent = to.parent;
        add.successor = to;
        if (to == this.head) {
            add.predecessor = null;
            to.predecessor = add;
            this.head = add;
        } else {
            add.predecessor = to.predecessor;
            to.predecessor.successor = add;
            to.predecessor = add;
        }
        ++this.size;
        return true;
    }

    boolean jumpAfter(Node to, Node jump) {
        if (to == null || jump == null || this.head == null || to.parent != this.head.parent || jump.parent != this.head.parent) {
            return false;
        }
        if (jump != this.head) {
            jump.predecessor.successor = jump.successor;
        }
        if (jump != this.tail) {
            jump.successor.predecessor = jump.predecessor;
        }
        jump.successor = to.successor;
        jump.predecessor = to;
        if (to == this.tail) {
            this.tail = jump;
        } else {
            to.successor.predecessor = jump;
        }
        to.successor = jump;
        return true;
    }

    boolean jumpBefore(Node to, Node jump) {
        if (to == null || jump == null || this.head == null || to.parent != this.head.parent || jump.parent != this.head.parent) {
            return false;
        }
        if (jump != this.head) {
            jump.predecessor.successor = jump.successor;
        }
        if (jump != this.tail) {
            jump.successor.predecessor = jump.predecessor;
        }
        jump.successor = to;
        jump.predecessor = to.predecessor;
        if (to == this.head) {
            this.head = jump;
        } else {
            to.predecessor.successor = jump;
        }
        to.predecessor = jump;
        return true;
    }

    boolean alternate(Node e, Node n) {
        if (e == null || n == null || this.head == null || e.parent != this.head.parent || n.parent != this.head.parent) {
            return false;
        }
        Node pre = e.predecessor;
        Node post = e.successor;
        e.predecessor = n.predecessor;
        if (n == this.head) {
            this.head = e;
        } else {
            n.predecessor.successor = e;
        }
        e.successor = n.successor;
        if (n == this.tail) {
            this.tail = e;
        } else {
            n.successor.predecessor = e;
        }
        n.predecessor = pre;
        if (pre != null) {
            pre.successor = n;
        } else {
            this.head = n;
        }
        n.successor = post;
        if (post != null) {
            post.predecessor = n;
        } else {
            this.tail = n;
        }
        return true;
    }

    boolean replace(Node to, NodeList with) {
        if (to == null || with.size == 0 || this.head == null || to.parent != this.head.parent || with.head.parent == this.head.parent) {
            return false;
        }
        with.head.predecessor = to.predecessor;
        if (to == this.head) {
            this.head = with.head;
        } else {
            to.predecessor.successor = with.head;
        }
        with.tail.successor = to.successor;
        if (to == this.tail) {
            this.tail = with.tail;
        } else {
            to.successor.predecessor = with.tail;
        }
        for (Node sibling : with) {
            sibling.parent = to.parent;
        }
        this.size = this.size - 1 + with.size;
        return true;
    }

    boolean replace(Node to, Node with) {
        if (to == null || with == null || this.head == null || to.parent != this.head.parent || with.parent == this.head.parent) {
            return false;
        }
        with.predecessor = to.predecessor;
        if (to == this.head) {
            this.head = with;
        } else {
            to.predecessor.successor = with;
        }
        with.successor = to.successor;
        if (to == this.tail) {
            this.tail = with;
        } else {
            to.successor.predecessor = with;
        }
        with.parent = to.parent;
        return true;
    }

    boolean remove(Node e) {
        if (e == null || this.head == null || e.parent != this.head.parent) {
            return false;
        }
        if (e == this.head) {
            this.head = this.head.successor;
            this.head.predecessor = null;
        } else if (e == this.tail) {
            this.tail = this.tail.predecessor;
            this.tail.successor = null;
        } else {
            e.predecessor.successor = e.successor;
            e.successor.predecessor = e.predecessor;
        }
        --this.size;
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeItr();
    }

    public int size() {
        return this.size;
    }

    public Node getFirst() {
        return this.head;
    }

    public Node getLast() {
        return this.tail;
    }

    public NodeList clone() {
        NodeList clone = new NodeList();
        for (Node node : this) {
            Node temp = node.clone();
            temp.parent = this.head.parent;
            clone.add(temp);
        }
        return clone;
    }

    NodeList clone(Node parent) {
        NodeList clone = new NodeList();
        for (Node node : this) {
            Node temp = node.clone();
            temp.parent = parent;
            clone.add(temp);
        }
        return clone;
    }

    private class NodeItr
    implements Iterator<Node> {
        Node cursor;

        NodeItr() {
            this.cursor = NodeList.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public Node next() {
            Node temp = this.cursor;
            this.cursor = this.cursor != NodeList.this.tail ? this.cursor.successor : null;
            return temp;
        }

        @Override
        public void remove() {
            NodeList.this.remove(this.cursor);
        }
    }
}

