/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.tree.NodeList;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public abstract class Node
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7323842986596895498L;
    Application app;
    int level = 0;
    Node parent = null;
    Node predecessor = null;
    Node successor = null;
    NodeList children = new NodeList();

    protected Node(Application app) {
        this.app = app;
    }

    public Node parent() {
        return this.parent;
    }

    public Node predecessor() {
        return this.predecessor;
    }

    public Node successor() {
        return this.successor;
    }

    public Application application() {
        return this.app;
    }

    boolean replaceWithChildren(Node tobeReplace) {
        if (tobeReplace.parent == null) {
            return false;
        }
        return tobeReplace.parent.children.replace(tobeReplace, this.children);
    }

    public NodeList children() {
        return this.children;
    }

    public abstract Node clone();

    boolean remove() {
        if (this.parent != null) {
            return this.parent.children.remove(this);
        }
        return false;
    }

    void add(Node node) {
        node.level = this.level + 1;
        node.parent = this;
        this.children.add(node);
    }

    Node treeNext() {
        if (this.children.size > 0) {
            return this.children.head;
        }
        return this.recursiveNext();
    }

    Node recursiveNext() {
        if (this.successor != null) {
            return this.successor;
        }
        if (this.parent != null) {
            return this.parent.recursiveNext();
        }
        return null;
    }

    boolean addChild(Node node) {
        node.parent = this;
        return this.children.append(node);
    }

    boolean followMe(Node node) {
        if (this.parent != null) {
            return this.parent.children.postend(this, node);
        }
        return false;
    }

    boolean leadMe(Node node) {
        if (this.parent != null) {
            return this.parent.children.preend(this, node);
        }
        return false;
    }

    boolean exchange(Node node) {
        if (this.parent == null || node == null || node.parent == null) {
            return false;
        }
        if (this.parent == node.parent) {
            this.parent.children.alternate(this, node);
        } else {
            Node tempPar = node.parent;
            Node tempPre = node.predecessor;
            Node tempSuc = node.successor;
            node.parent = this.parent;
            node.predecessor = this.predecessor;
            node.successor = this.successor;
            if (this.predecessor != null) {
                this.predecessor.successor = node;
            } else {
                this.parent.children.head = node;
            }
            if (this.successor != null) {
                this.successor.predecessor = node;
            } else {
                this.parent.children.tail = node;
            }
            this.parent = tempPar;
            this.predecessor = tempPre;
            this.successor = tempSuc;
            if (this.predecessor != null) {
                this.predecessor.successor = this;
            } else {
                this.parent.children.head = this;
            }
            if (this.successor != null) {
                this.successor.predecessor = this;
            } else {
                this.parent.children.tail = this;
            }
        }
        return true;
    }

    void computeLevel(int baseLevel) {
        this.level = baseLevel;
        for (Node child : this.children) {
            child.computeLevel(this.level + 1);
        }
    }

    public abstract void render(CarrotInterpreter var1, Writer var2) throws CarrotException, IOException;

    public abstract String getName();
}

