/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.tree;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.lib.Macro;
import au.com.codeka.carrot.lib.Tag;
import au.com.codeka.carrot.parse.MacroToken;
import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.TreeRebuilder;
import au.com.codeka.carrot.util.Log;
import java.io.IOException;
import java.io.Writer;

public class MacroNode
extends Node {
    private static final long serialVersionUID = 5037873030399458427L;
    private MacroToken master;
    private Log log;
    String endName = null;

    public MacroNode(Application app, MacroToken token) throws ParseException {
        super(app);
        this.master = token;
        this.log = new Log(app.getConfiguration());
        Macro macro = (Macro)app.getConfiguration().getMacroLibrary().fetch(this.master.getMacroName());
        if (macro == null) {
            throw new ParseException("Can't find macro >>> " + this.master.getMacroName());
        }
        this.endName = macro.getEndMacroName();
    }

    @Override
    public void render(CarrotInterpreter interpreter, Writer writer) throws CarrotException, IOException {
        Tag tag = (Tag)this.app.getConfiguration().getTagLibrary().fetch(this.master.getMacroName());
        if (tag != null) {
            this.log.debug("Treat macro as tag with same name: %s", this.master.getMacroName());
            interpreter.setLevel(this.level);
            tag.interpreter(this.children(), this.master.getHelpers(), interpreter, writer);
        } else {
            this.log.warn("Skiping handless macro while rendering: %s", this.master.getMacroName());
        }
    }

    public void refactor(TreeRebuilder rebuilder) throws ParseException {
        Macro macro = (Macro)this.app.getConfiguration().getMacroLibrary().fetch(this.master.getMacroName());
        macro.refactor(this, this.master.getHelpers(), rebuilder);
    }

    public String toString() {
        return this.master.toString();
    }

    @Override
    public String getName() {
        return this.master.getMacroName();
    }

    @Override
    public Node clone() {
        try {
            MacroNode clone = new MacroNode(this.app, this.master);
            clone.children = this.children.clone(clone);
            return clone;
        }
        catch (ParseException e) {
            throw new InternalError();
        }
    }
}

