/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.template;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.base.Configuration;
import au.com.codeka.carrot.base.Context;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.resource.ResourceName;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class Processor {
    protected Context context;
    protected Application application;
    private boolean used;

    public Processor(Application application) {
        this.application = application;
        this.context = new Context(application);
    }

    public Configuration getConfiguration() {
        return this.context.getConfiguration();
    }

    public String render(String templateFile, Map<String, Object> bindings) throws CarrotException {
        return this.render(templateFile, bindings, this.context.getConfiguration().getEncoding());
    }

    public String render(String templateFile, Map<String, Object> bindings, String encoding) throws CarrotException {
        StringWriter writer = new StringWriter();
        this.render(templateFile, bindings, writer, encoding);
        return writer.getBuffer().toString();
    }

    public void render(String templateFile, Map<String, Object> bindings, Writer writer) throws CarrotException {
        this.render(templateFile, bindings, writer, this.context.getConfiguration().getEncoding());
    }

    public void render(String templateFile, Map<String, Object> bindings, Writer writer, String encoding) throws CarrotException {
        if (this.used) {
            throw new IllegalStateException("Cannot use Processor more than once.");
        }
        this.used = true;
        this.context.initBindings(bindings, 2);
        try {
            ResourceName resourceName = this.application.getConfiguration().getResourceLocater().findResource(templateFile);
            CarrotInterpreter interpreter = new CarrotInterpreter(this.context);
            interpreter.render(resourceName, writer);
        }
        catch (IOException e) {
            throw new CarrotException(e);
        }
    }
}

