/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.template;

import au.com.codeka.carrot.base.CarrotException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LazyBindings
implements Map<String, Object> {
    private Map<String, Object> bins = new HashMap<String, Object>();
    private Set<String> keys = new HashSet<String>();
    private Map<String, String> lazies = new HashMap<String, String>();
    private Map<String, Method> methods = new HashMap<String, Method>();

    public void config(Map<String, String> props) {
        this.lazies = props;
        this.keys.addAll(props.keySet());
        this.bins.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public Object get(Object key) {
        this.checkKey(key);
        if (this.keys.contains(key)) {
            Object value = this.bins.get(key);
            if (value == null) {
                try {
                    value = this.getFromDataSource(key);
                }
                catch (CarrotException carrotException) {
                    // empty catch block
                }
            }
            return value;
        }
        return null;
    }

    private Object getFromDataSource(Object key) throws CarrotException {
        try {
            String lazy = this.lazies.get(key);
            if (!this.methods.containsKey(lazy)) {
                int sep = lazy.lastIndexOf(46);
                Class<?> c = Class.forName(lazy.substring(0, sep));
                Method method = c.getDeclaredMethod(lazy.substring(sep + 1), new Class[0]);
                this.methods.put(lazy, method);
            }
            return this.methods.get(lazy).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new CarrotException(e);
        }
    }

    @Override
    public Object put(String name, Object value) {
        this.checkKey(name);
        this.keys.add(name);
        return this.bins.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        if (toMerge == null) {
            throw new NullPointerException("toMerge map is null");
        }
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        this.keys.remove(key);
        if (this.bins.containsKey(key)) {
            this.lazies.remove(key);
            return this.bins.remove(key);
        }
        try {
            Object value = this.getFromDataSource(key);
            this.lazies.remove(key);
            return value;
        }
        catch (CarrotException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.bins.clear();
        this.lazies.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.bins.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.keys;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public Collection<Object> values() {
        for (String key : this.lazies.keySet()) {
            try {
                this.bins.put(key, this.getFromDataSource(key));
            }
            catch (CarrotException carrotException) {}
        }
        return this.bins.values();
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key should be a String");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can not be empty");
        }
    }
}

