/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.script;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.base.Context;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.TokenParser;
import au.com.codeka.carrot.script.CarrotContext;
import au.com.codeka.carrot.script.CarrotEngineFactory;
import au.com.codeka.carrot.util.Log;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class CarrotEngine
implements ScriptEngine {
    private String defaultBindings = "javax.script.SimpleBindings";
    private CarrotEngineFactory factory;
    private CarrotContext context;
    private Log log;

    public CarrotEngine() {
        this.factory = new CarrotEngineFactory();
        this.context = new CarrotContext(this.factory.globalBindings);
        this.log = new Log(this.context.getApplication().getConfiguration());
        this.initGlobalData();
    }

    public CarrotEngine(CarrotEngineFactory fac) {
        this.factory = fac;
        this.context = new CarrotContext(this.factory.globalBindings);
        this.initGlobalData();
    }

    private void initGlobalData() {
    }

    @Override
    public Bindings createBindings() {
        try {
            return (Bindings)Class.forName(this.defaultBindings).newInstance();
        }
        catch (Exception e) {
            this.log.warn("Could not create bindings, using defaults: ", e);
            return new SimpleBindings();
        }
    }

    @Override
    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        TokenParser parser = new TokenParser(script);
        CarrotInterpreter interpreter = new CarrotInterpreter((Context)((Object)ctx));
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        TokenParser parser;
        try {
            parser = new TokenParser(reader);
        }
        catch (ParseException e) {
            throw new ScriptException(e.getMessage());
        }
        CarrotInterpreter interpreter = new CarrotInterpreter((Context)((Object)ctx));
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object eval(String script) throws ScriptException {
        TokenParser parser = new TokenParser(script);
        CarrotInterpreter interpreter = new CarrotInterpreter(this.context);
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        TokenParser parser;
        try {
            parser = new TokenParser(reader);
        }
        catch (ParseException e) {
            throw new ScriptException(e.getMessage());
        }
        CarrotInterpreter interpreter = new CarrotInterpreter(this.context);
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public Object eval(String script, Bindings n) throws ScriptException {
        TokenParser parser = new TokenParser(script);
        CarrotContext ctx = new CarrotContext(this.factory.globalBindings);
        ctx.setBindings(n, 100);
        CarrotInterpreter interpreter = new CarrotInterpreter(ctx);
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public Object eval(Reader reader, Bindings n) throws ScriptException {
        TokenParser parser;
        try {
            parser = new TokenParser(reader);
        }
        catch (ParseException e) {
            throw new ScriptException(e.getMessage());
        }
        CarrotContext ctx = new CarrotContext(this.factory.globalBindings);
        ctx.setBindings(n, 100);
        CarrotInterpreter interpreter = new CarrotInterpreter(ctx);
        try {
            return CarrotEngine.render(interpreter, parser);
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    private static String render(CarrotInterpreter interpreter, TokenParser parser) throws CarrotException, IOException {
        StringWriter writer = new StringWriter();
        interpreter.render(parser, (Writer)writer);
        return writer.toString();
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public void setContext(ScriptContext scontext) {
        this.context = (CarrotContext)scontext;
    }
}

