/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.script;

import au.com.codeka.carrot.base.Context;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class CarrotContext
extends Context
implements ScriptContext {
    private Writer errw;
    private Writer wtr;
    private Reader rd;

    public CarrotContext(Bindings global) {
        this.application.setGlobalBindings(global);
        this.sessionBindings = new SimpleBindings();
    }

    @Override
    public int getAttributesScope(String name) {
        if (this.sessionBindings.containsKey(name)) {
            return 100;
        }
        if (this.application.getGlobalBindings().containsKey(name)) {
            return 200;
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return (Bindings)this.sessionBindings;
            }
            case 200: {
                return (Bindings)this.application.getGlobalBindings();
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public Writer getErrorWriter() {
        return this.errw;
    }

    @Override
    public Reader getReader() {
        return this.rd;
    }

    @Override
    public List<Integer> getScopes() {
        ArrayList<Integer> scopes = new ArrayList<Integer>();
        scopes.add(100);
        scopes.add(200);
        return scopes;
    }

    @Override
    public Writer getWriter() {
        return this.wtr;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        switch (scope) {
            case 100: {
                if (this.sessionBindings == null) {
                    return null;
                }
                return this.sessionBindings.remove(name);
            }
            case 200: {
                if (this.application.getGlobalBindings() == null) {
                    return null;
                }
                return this.application.getGlobalBindings().remove(name);
            }
        }
        throw new IllegalArgumentException("Illegal scope value.");
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        if (bindings == null) {
            throw new NullPointerException("Bindings cannot be null.");
        }
        switch (scope) {
            case 100: {
                this.sessionBindings = bindings;
                break;
            }
            case 200: {
                this.application.setGlobalBindings(bindings);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal scope value.");
            }
        }
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errw = writer;
    }

    @Override
    public void setReader(Reader reader) {
        this.rd = reader;
    }

    @Override
    public void setWriter(Writer writer) {
        this.wtr = writer;
    }
}

