/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.parse;

import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.Token;

public class Tokenizer {
    private char[] is;
    private int currPost = 0;
    private int tokenStart = 0;
    private int tokenLength = 0;
    private int tokenKind = -1;
    private int length = 0;
    private int lastStart = 0;
    private int inComment = 0;

    public void init(String inputstream) {
        this.is = inputstream.toCharArray();
        this.length = inputstream.length();
        this.currPost = 0;
        this.tokenStart = 0;
        this.tokenKind = -1;
        this.lastStart = 0;
        this.inComment = 0;
    }

    public Token getNextToken() throws ParseException {
        int c = 0;
        block9: while (this.currPost < this.length) {
            c = this.is[this.currPost++];
            if (this.currPost == this.length) {
                return this.getEndToken();
            }
            switch (c) {
                case 123: {
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        switch (c) {
                            case 35: {
                                if (this.inComment++ > 0) continue block9;
                                this.tokenLength = this.currPost - this.tokenStart - 1;
                                if (this.tokenLength > 0) {
                                    this.lastStart = this.tokenStart;
                                    this.tokenStart = --this.currPost;
                                    this.tokenKind = c;
                                    --this.inComment;
                                    return this.newToken(0);
                                }
                                this.tokenKind = c;
                                continue block9;
                            }
                            case 33: 
                            case 37: 
                            case 123: {
                                if (this.inComment > 0 || !this.matchToken((char)c) && this.tokenKind > 0) continue block9;
                                this.tokenLength = this.currPost - this.tokenStart - 1;
                                if (this.tokenLength > 0) {
                                    this.lastStart = this.tokenStart;
                                    this.tokenStart = --this.currPost;
                                    this.tokenKind = c;
                                    return this.newToken(0);
                                }
                                this.tokenKind = c;
                                continue block9;
                            }
                        }
                        continue block9;
                    }
                    return this.getEndToken();
                }
                case 33: 
                case 37: 
                case 125: {
                    if (this.inComment > 0 || !this.matchToken((char)c)) continue block9;
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        if (c != 125) continue block9;
                        this.tokenLength = this.currPost - this.tokenStart + 1;
                        if (this.tokenLength <= 0) continue block9;
                        this.lastStart = this.tokenStart;
                        this.tokenStart = ++this.currPost;
                        int kind = this.tokenKind;
                        this.tokenKind = 0;
                        return this.newToken(kind);
                    }
                    return this.getEndToken();
                }
                case 35: {
                    if (!this.matchToken((char)c)) continue block9;
                    if (this.currPost < this.length) {
                        c = this.is[this.currPost];
                        if (c != 125 || --this.inComment > 0) continue block9;
                        this.tokenLength = this.currPost - this.tokenStart + 1;
                        if (this.tokenLength <= 0) continue block9;
                        this.lastStart = this.tokenStart;
                        this.tokenStart = ++this.currPost;
                        this.tokenKind = 0;
                        return this.newToken(35);
                    }
                    return this.getEndToken();
                }
            }
            if (this.tokenKind != -1) continue;
            this.tokenKind = 0;
        }
        return null;
    }

    private Token getEndToken() throws ParseException {
        this.tokenLength = this.currPost - this.tokenStart;
        int type = 0;
        if (this.inComment > 0) {
            type = 35;
        }
        return Token.newToken(type, String.valueOf(this.is, this.tokenStart, this.tokenLength));
    }

    private Token newToken(int kind) throws ParseException {
        Token token = Token.newToken(kind, String.copyValueOf(this.is, this.lastStart, this.tokenLength));
        return token;
    }

    private boolean matchToken(char kind) {
        if (kind == '{') {
            return this.tokenKind == 125;
        }
        if (kind == '}') {
            return this.tokenKind == 123;
        }
        return kind == this.tokenKind;
    }
}

