/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.parse;

import au.com.codeka.carrot.parse.ParseException;
import au.com.codeka.carrot.parse.Token;
import au.com.codeka.carrot.parse.Tokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;

public class TokenParser {
    private Tokenizer tm = new Tokenizer();
    private Token token;
    private boolean proceeding = true;

    public TokenParser(String text) {
        this.tm.init(text);
    }

    public TokenParser(Reader reader) throws ParseException {
        this.init(reader);
    }

    public void init(String text) {
        this.tm.init(text);
        this.token = null;
        this.proceeding = true;
    }

    public void init(Reader reader) throws ParseException {
        BufferedReader br = new BufferedReader(reader);
        StringBuffer buff = new StringBuffer();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                buff.append(line);
                buff.append("\n");
            }
        }
        catch (IOException e) {
            throw new ParseException("read template reader fault.", e.getCause());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new ParseException("read template reader fault.", e.getCause());
            }
        }
        this.tm.init(buff.toString());
        this.token = null;
        this.proceeding = true;
    }

    public boolean hasNext() throws ParseException {
        if (this.proceeding) {
            this.token = this.tm.getNextToken();
            if (this.token != null) {
                return true;
            }
            this.proceeding = false;
            return false;
        }
        return false;
    }

    public Token next() throws ParseException {
        if (this.proceeding) {
            if (this.token == null) {
                Token tk = this.tm.getNextToken();
                if (tk == null) {
                    this.proceeding = false;
                    throw new NoSuchElementException();
                }
                return tk;
            }
            Token last = this.token;
            this.token = null;
            return last;
        }
        throw new NoSuchElementException();
    }
}

