/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.parse;

import au.com.codeka.carrot.parse.ParseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FilterParser
implements Serializable {
    private static final long serialVersionUID = 2328268066571880284L;
    private String content;
    private String var;
    private List<String> filters;
    private List<String[]> argss;

    public FilterParser(String cont) {
        this.content = cont;
    }

    public String getVariable() {
        return this.var;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public List<String[]> getArgss() {
        return this.argss;
    }

    public void parse() throws ParseException {
        this.filters = new ArrayList<String>();
        this.argss = new ArrayList<String[]>();
        int pointer = this.content.indexOf(124);
        if (pointer < 0) {
            this.var = this.content;
        } else {
            this.var = this.content.substring(0, pointer).trim();
            this.content = this.content.substring(pointer + 1).trim();
            while (this.content.length() > 0) {
                this.parseFilter(this.content);
            }
        }
    }

    private void parseFilter(String filterString) throws ParseException {
        int postPipe;
        int postColon = filterString.indexOf(58);
        if (postColon == (postPipe = filterString.indexOf(124))) {
            this.filters.add(filterString);
            this.argss.add(null);
            this.content = "";
        }
        if (postColon > 0 && (postColon < postPipe || postPipe < 0)) {
            ArrayList<String> args = new ArrayList<String>();
            this.filters.add(filterString.substring(0, postColon).trim());
            String argString = filterString.substring(postColon + 1).trim();
            while ((argString = this.parseArg(argString, args)) != null) {
            }
            this.argss.add(args.toArray(new String[0]));
        }
        if (postPipe > 0 && (postPipe < postColon || postColon < 0)) {
            this.filters.add(filterString.substring(0, postPipe).trim());
            this.argss.add(null);
            this.content = filterString.substring(postPipe + 1).trim();
        }
    }

    private String parseArg(String argString, List<String> args) throws ParseException {
        if (argString.charAt(0) == '\"') {
            int post = argString.substring(1).indexOf(34);
            if (post < 0) {
                throw new ParseException("Filter argument doesn't match quotes >>> " + this.getVariable());
            }
            args.add(argString.substring(0, post + 2));
            if (post < argString.length() - 3) {
                if ((argString = argString.substring(post + 2).trim()).charAt(0) == '|') {
                    this.content = argString.substring(1).trim();
                    return null;
                }
                if (argString.charAt(0) == ',') {
                    return argString.substring(1).trim();
                }
                throw new ParseException("Filter argument is illegal >>> " + this.getVariable());
            }
        } else if (argString.charAt(0) == '\'') {
            int post = argString.substring(1).indexOf(39);
            if (post < 0) {
                throw new ParseException("Filter argument doesn't match quotes >>> " + this.getVariable());
            }
            args.add(argString.substring(0, post + 2));
            if (post < argString.length() - 3) {
                if ((argString = argString.substring(post + 2).trim()).charAt(0) == '|') {
                    this.content = argString.substring(1).trim();
                    return null;
                }
                if (argString.charAt(0) == ',') {
                    return argString.substring(1).trim();
                }
                throw new ParseException("Filter argument is illegal >>> " + this.getVariable());
            }
        } else {
            int postComma = argString.indexOf(44);
            int postPipe = argString.indexOf(124);
            if (postComma > 0 && (postPipe > postComma || postPipe < 0)) {
                args.add(argString.substring(0, postComma).trim());
                if (postComma < argString.length() - 1) {
                    return argString.substring(postComma + 1).trim();
                }
            }
            if (postPipe >= 0 && (postPipe < postComma || postComma < 0)) {
                if (postPipe > 0) {
                    args.add(argString.substring(0, postPipe).trim());
                }
                if (postPipe < argString.length() - 1) {
                    this.content = argString.substring(postPipe + 1).trim();
                    return null;
                }
            }
            if (postComma == 0) {
                throw new ParseException("Filter lost some argument >>> " + this.getVariable());
            }
            if (postComma == postPipe) {
                args.add(argString);
            }
        }
        this.content = "";
        return null;
    }
}

