/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.filter;

import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Filter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Filter
implements Filter {
    final String[] NOSTR = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    final String md5 = "MD5";

    private String byteToArrayString(byte bByte) {
        int temp = bByte;
        if (temp < 0) {
            temp += 256;
        }
        int iD1 = temp / 16;
        int iD2 = temp % 16;
        return this.NOSTR[iD1] + this.NOSTR[iD2];
    }

    private String byteToString(byte[] bByte) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 0; i < bByte.length; ++i) {
            sBuffer.append(this.byteToArrayString(bByte[i]));
        }
        return sBuffer.toString();
    }

    public String md5(String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        return this.byteToString(md.digest(str.getBytes()));
    }

    @Override
    public Object filter(Object object, CarrotInterpreter interpreter, String ... arg) throws InterpretException {
        try {
            if (object instanceof String) {
                return this.md5((String)object);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InterpretException(e);
        }
        return object;
    }

    @Override
    public String getName() {
        return "md5";
    }
}

