/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib.filter;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Filter;
import au.com.codeka.carrot.util.ObjectStringEqual;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ContainFilter
implements Filter {
    @Override
    public Object filter(Object object, CarrotInterpreter interpreter, String ... arg) throws CarrotException {
        Object argObj;
        if (object == null) {
            return false;
        }
        if (arg.length != 1) {
            throw new InterpretException("filter contain expects 1 arg >>> " + arg.length);
        }
        boolean isNull = false;
        if (arg[0].startsWith("'") || arg[0].startsWith("\"")) {
            argObj = arg[0].substring(1, arg[0].length() - 1);
        } else {
            argObj = interpreter.retraceVariable(arg[0]);
            isNull = argObj == null;
            if (isNull) {
                argObj = arg[0];
            }
        }
        if (object instanceof Iterable) {
            Iterator it = ((Iterable)object).iterator();
            return this.iteratorContain(it, isNull, argObj);
        }
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(object, i);
                if (!(item == null ? isNull : ObjectStringEqual.evaluate(item, argObj))) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Map) {
            Iterator it = ((Map)object).values().iterator();
            return this.iteratorContain(it, isNull, argObj);
        }
        if (object instanceof String) {
            return object.toString().contains(Objects.toString(argObj));
        }
        if (object instanceof Iterator) {
            return this.iteratorContain((Iterator)object, isNull, argObj);
        }
        throw new InterpretException("Filter contain can't be applied to: " + object.getClass().getName());
    }

    @Override
    public String getName() {
        return "contain";
    }

    private boolean iteratorContain(Iterator<?> it, boolean isNull, Object argObj) {
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item == null ? isNull : ObjectStringEqual.evaluate(item, argObj))) continue;
            return true;
        }
        return false;
    }
}

