/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.lib;

import au.com.codeka.carrot.base.Configuration;
import au.com.codeka.carrot.util.Log;
import java.util.HashMap;
import java.util.Map;

public abstract class Library<T> {
    private Map<String, T> lib = new HashMap<String, T>();
    private Log log;
    private final String kind;

    protected Library(Configuration config, String kind) {
        this.kind = kind;
        this.log = new Log(config);
        this.initialize();
    }

    protected abstract void initialize();

    public T fetch(String item) {
        String key = item.toLowerCase();
        if (this.lib.containsKey(key)) {
            return this.lib.get(key);
        }
        throw new RuntimeException("No " + this.kind + ": " + item);
    }

    public void register(String name, T obj) {
        this.lib.put(name.toLowerCase(), obj);
        this.log.debug("Registered %s: %s -> %s", this.kind, name.toLowerCase(), obj.getClass().getName());
    }

    public boolean isRegistered(String name) {
        return this.lib.containsKey(name.toLowerCase());
    }
}

