/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.interpret;

import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.interpret.CarrotInterpreter;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.lib.Filter;
import au.com.codeka.carrot.parse.FilterParser;
import au.com.codeka.carrot.parse.ParseException;
import java.util.List;

public class VariableFilter {
    public static Object compute(String varString, CarrotInterpreter interpreter) throws CarrotException {
        if (varString.startsWith("'") && varString.endsWith("'") || varString.startsWith("\"") && varString.endsWith("\"")) {
            return varString.substring(1, varString.length() - 1);
        }
        FilterParser fp = new FilterParser(varString);
        try {
            fp.parse();
        }
        catch (ParseException e) {
            throw new InterpretException(e.getMessage());
        }
        Object var = interpreter.retraceVariable(fp.getVariable());
        List<String> filters = fp.getFilters();
        if (filters.isEmpty()) {
            return var;
        }
        List<String[]> argss = fp.getArgss();
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)interpreter.getConfiguration().getFilterLibrary().fetch(filters.get(i));
            String[] args = argss.get(i);
            var = args == null ? filter.filter(var, interpreter, new String[0]) : filter.filter(var, interpreter, args);
        }
        return var;
    }
}

