/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.interpret;

import au.com.codeka.carrot.base.Application;
import au.com.codeka.carrot.base.CarrotException;
import au.com.codeka.carrot.base.Configuration;
import au.com.codeka.carrot.base.Context;
import au.com.codeka.carrot.interpret.FloorBindings;
import au.com.codeka.carrot.interpret.InterpretException;
import au.com.codeka.carrot.parse.TokenParser;
import au.com.codeka.carrot.resource.ResourceName;
import au.com.codeka.carrot.tree.Node;
import au.com.codeka.carrot.tree.TreeParser;
import au.com.codeka.carrot.util.ListOrderedMap;
import au.com.codeka.carrot.util.Log;
import au.com.codeka.carrot.util.Variable;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;

public class CarrotInterpreter
implements Cloneable {
    public static final String CHILD_FLAG = "'IS\"CHILD";
    public static final String PARENT_FLAG = "'IS\"PARENT";
    public static final String INSERT_FLAG = "'IS\"INSERT";
    public static final String SEMI_RENDER = "'SEMI\"FORMAL";
    public static final String BLOCK_LIST = "'BLK\"LIST";
    public static final String SEMI_BLOCK = "<K2C9OL7B>";
    static final String VAR_DATE = "now";
    static final String VAR_PATH = "workspace";
    private int level = 1;
    private FloorBindings runtime;
    private Context context;
    private Log log;
    private ResourceName workspace;

    public CarrotInterpreter(Context context) {
        this.context = context;
        this.runtime = new FloorBindings();
        this.log = new Log(context.getApplication().getConfiguration());
    }

    private CarrotInterpreter() {
    }

    public Configuration getConfiguration() {
        return this.context.getConfiguration();
    }

    public CarrotInterpreter clone() {
        CarrotInterpreter compiler = new CarrotInterpreter();
        compiler.context = this.context;
        compiler.runtime = this.runtime.clone();
        compiler.log = this.log;
        return compiler;
    }

    public void init() {
        this.runtime = new FloorBindings();
        this.level = 1;
    }

    public ResourceName findResource(String name, boolean resolveName) throws CarrotException, IOException {
        if (resolveName) {
            name = this.resolveString(name);
        }
        return this.getApplication().getConfiguration().getResourceLocater().findResource(this.getWorkspace(), name);
    }

    public void render(TokenParser tokenParser, Writer writer) throws CarrotException, IOException {
        this.workspace = null;
        this.render(new TreeParser(this.context.getApplication()).parse(tokenParser), writer);
    }

    public void render(ResourceName resourceName, Writer writer) throws CarrotException, IOException {
        this.workspace = resourceName.getParent();
        this.render(this.context.getApplication().getParseResult(resourceName), writer);
    }

    private void render(Node root, Writer writer) throws CarrotException, IOException {
        for (Node node : root.children()) {
            node.render(this, writer);
        }
        if (this.runtime.get(CHILD_FLAG, 1) != null && this.runtime.get(INSERT_FLAG, 1) == null) {
            StringBuilder sb = new StringBuilder((String)this.fetchRuntimeScope(SEMI_RENDER, 1));
            ListOrderedMap blockList = (ListOrderedMap)this.fetchRuntimeScope(BLOCK_LIST, 1);
            for (ListOrderedMap.Item item : blockList) {
                int index;
                String replace = SEMI_BLOCK + item.getKey();
                while ((index = sb.indexOf(replace)) > 0) {
                    sb.delete(index, index + replace.length());
                    sb.insert(index, item.getValue());
                }
            }
            writer.write(sb.toString());
        }
    }

    public Object retraceVariable(String variableName) throws CarrotException {
        if (variableName == null || variableName.trim().length() == 0) {
            return "";
        }
        Variable var = new Variable(variableName);
        String varName = var.getName();
        Object obj = this.runtime.get(varName, this.level);
        int lvl = this.level;
        while (obj == null && lvl > 1) {
            obj = this.runtime.get(varName, --lvl);
        }
        if (obj == null) {
            obj = this.context.getAttribute(varName);
        }
        if (obj == null) {
            if (VAR_DATE.equals(variableName)) {
                return new Date();
            }
            if (VAR_PATH.equals(variableName)) {
                return this.getWorkspace();
            }
        }
        if (obj != null) {
            obj = var.resolve(obj);
        }
        return obj;
    }

    public String resolveString(String variable) throws CarrotException {
        if (variable == null || variable.trim().length() == 0) {
            throw new InterpretException("Variable name is required.");
        }
        if (variable.startsWith("\"") || variable.startsWith("'")) {
            return variable.substring(1, variable.length() - 1);
        }
        Object val = this.retraceVariable(variable);
        if (val == null) {
            return variable;
        }
        return val.toString();
    }

    public Object resolveObject(String variable) throws CarrotException {
        if (variable == null || variable.trim().length() == 0) {
            throw new InterpretException("Variable name is required.");
        }
        if (variable.startsWith("\"") || variable.startsWith("'")) {
            return variable.substring(1, variable.length() - 1);
        }
        Object val = this.retraceVariable(variable);
        if (val == null) {
            return variable;
        }
        return val;
    }

    public void assignRuntimeScope(String name, Object item) {
        this.runtime.put(name, item, this.level);
    }

    public void assignRuntimeScope(String name, Object item, int level) {
        this.runtime.put(name, item, level);
    }

    public Object fetchRuntimeScope(String name, int level) {
        return this.runtime.get(name, level);
    }

    public Object fetchRuntimeScope(String name) {
        return this.runtime.get(name, this.level);
    }

    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public int getLevel() {
        return this.level;
    }

    public Context getContext() {
        return this.context;
    }

    public Application getApplication() {
        return this.context.getApplication();
    }

    public ResourceName getWorkspace() {
        return this.workspace;
    }

    public void setCurrentResource(ResourceName resourceName) {
        this.workspace = resourceName.getParent();
    }
}

