/*
 * Decompiled with CFR 0.152.
 */
package au.com.codeka.carrot.base;

import au.com.codeka.carrot.lib.FilterLibrary;
import au.com.codeka.carrot.lib.MacroLibrary;
import au.com.codeka.carrot.lib.TagLibrary;
import au.com.codeka.carrot.resource.FileResourceLocater;
import au.com.codeka.carrot.resource.ResourceLocater;
import au.com.codeka.carrot.util.Log;
import java.util.Locale;
import java.util.TimeZone;

public class Configuration {
    private String encoding;
    private Locale locale;
    private TimeZone timezone;
    private ResourceLocater resourceLocater = new FileResourceLocater(this, ".");
    private boolean parseCacheEnabled = true;
    private Logger logger = new Log.DefaultLogger();
    private FilterLibrary filterLibrary = new FilterLibrary(this);
    private TagLibrary tagLibrary = new TagLibrary(this);
    private MacroLibrary macroLibrary = new MacroLibrary(this);

    protected Configuration() {
    }

    public FilterLibrary getFilterLibrary() {
        return this.filterLibrary;
    }

    public MacroLibrary getMacroLibrary() {
        return this.macroLibrary;
    }

    public TagLibrary getTagLibrary() {
        return this.tagLibrary;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public void setResourceLocater(ResourceLocater resourceLocater) {
        this.resourceLocater = resourceLocater;
    }

    public ResourceLocater getResourceLocater() {
        return this.resourceLocater;
    }

    public void setParseCacheEnabled(boolean enabled) {
        this.parseCacheEnabled = enabled;
    }

    public boolean isParseCacheEnabled() {
        return this.parseCacheEnabled;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static interface Logger {
        public static final int WARNING = 2;
        public static final int INFO = 1;
        public static final int DEBUG = 0;

        public void write(int var1, String var2);
    }
}

