/*
 * Decompiled with CFR 0.152.
 */
package au.com.anthonybruno.creator;

import au.com.anthonybruno.creator.FlatFileFactory;
import au.com.anthonybruno.record.Records;
import au.com.anthonybruno.record.factory.RecordFactory;
import au.com.anthonybruno.settings.CsvSettings;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;

public class CsvFactory
extends FlatFileFactory<CsvSettings> {
    private final CsvWriterSettings csvWriterSettings = new CsvWriterSettings();

    public CsvFactory(CsvSettings settings, RecordFactory recordFactory) {
        super(settings, recordFactory);
        ((CsvFormat)this.csvWriterSettings.getFormat()).setDelimiter(settings.getDelimiter());
    }

    @Override
    public String createString(int rowsToGenerate) {
        StringWriter stringWriter = new StringWriter();
        CsvWriter csvWriter = new CsvWriter((Writer)stringWriter, this.csvWriterSettings);
        this.writeValues(csvWriter, rowsToGenerate);
        return stringWriter.toString();
    }

    private void writeValues(CsvWriter writer, int rowsToGenerate) {
        Records records = this.recordFactory.generateRecords(rowsToGenerate);
        if (((CsvSettings)this.settings).isIncludingHeaders()) {
            records.getFields().forEach(arg_0 -> ((CsvWriter)writer).addValue(arg_0));
            writer.writeValuesToRow();
        }
        records.forEach(record -> {
            record.forEach(arg_0 -> ((CsvWriter)writer).addValue(arg_0));
            writer.writeValuesToRow();
        });
        writer.close();
    }

    @Override
    public File createFile(File file, int rowsToGenerate) {
        CsvWriter csvWriter = new CsvWriter(file, this.csvWriterSettings);
        this.writeValues(csvWriter, rowsToGenerate);
        return file;
    }
}

