/*
 * Decompiled with CFR 0.152.
 */
package au.com.agiledigital.healthchecker;

import au.com.agiledigital.healthchecker.HealthChecker;
import au.com.agiledigital.healthchecker.HealthCheckerFactory;
import au.com.agiledigital.healthchecker.checkers.BadConfigurationHealthChecker;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.PlayException;
import play.api.inject.Injector;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set$;
import scala.util.control.NonFatal$;

public final class HealthCheckFactory$ {
    public static HealthCheckFactory$ MODULE$;

    static {
        new HealthCheckFactory$();
    }

    public Iterable<HealthChecker> processConfiguration(Configuration configuration, Environment environment, Injector injector) {
        return (Iterable)configuration.subKeys().flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(configuration.getOptional(key, ConfigLoader$.MODULE$.configurationLoader()).map((Function1 & Serializable & scala.Serializable)config -> MODULE$.initChecker((String)key, (Configuration)config, environment, injector))), Set$.MODULE$.canBuildFrom());
    }

    private HealthChecker initChecker(String name, Configuration config, Environment environment, Injector injector) {
        return (HealthChecker)config.getOptional("provider", ConfigLoader$.MODULE$.stringLoader()).map((Function1 & Serializable & scala.Serializable)clazzName -> MODULE$.createChecker((String)clazzName, name, config, environment, injector)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No provider name specified in [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config}));
            PlayException error = config.reportError("provider", message, (Option)None$.MODULE$);
            Logger$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> message, (Function0 & Serializable & scala.Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
            return new BadConfigurationHealthChecker(name, message, (Option<Throwable>)new Some((Object)error));
        });
    }

    private HealthChecker createChecker(String clazzName, String keyName, Configuration config, Environment environment, Injector injector) {
        HealthChecker healthChecker;
        try {
            Class<?> factoryClazz = Class.forName(clazzName, true, environment.classLoader());
            HealthCheckerFactory factory = (HealthCheckerFactory)injector.instanceOf(factoryClazz);
            healthChecker = factory.createHealthChecker(config);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            String message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No valid constructor found for [", "] in [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazzName, config}));
            PlayException error = config.reportError("provider", message, (Option)new Some((Object)e));
            Logger$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> message, (Function0 & Serializable & scala.Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
            BadConfigurationHealthChecker badConfigurationHealthChecker = new BadConfigurationHealthChecker(keyName, message, (Option<Throwable>)new Some((Object)error));
            healthChecker = badConfigurationHealthChecker;
        }
        return healthChecker;
    }

    private HealthCheckFactory$() {
        MODULE$ = this;
    }
}

