/*
 * Decompiled with CFR 0.152.
 */
package au.com.agiledigital.healthchecker;

import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import au.com.agiledigital.healthchecker.CancellableHealthChecker;
import au.com.agiledigital.healthchecker.HealthCheckResult;
import au.com.agiledigital.healthchecker.HealthCheckStatus$;
import au.com.agiledigital.healthchecker.HealthChecker;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import play.api.Logger$;
import play.api.libs.concurrent.Execution;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\t\u0011\u0002*Z1mi\"\u001c\u0005.Z2l\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0007iK\u0006dG\u000f[2iK\u000e\\WM\u001d\u0006\u0003\u000b\u0019\tA\"Y4jY\u0016$\u0017nZ5uC2T!a\u0002\u0005\u0002\u0007\r|WNC\u0001\n\u0003\t\tWo\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0015\r\u0011\"\u0003\u0015\u00039AW-\u00197uQ\u000eCWmY6feN,\u0012!\u0006\t\u0004-y\tcBA\f\u001d\u001d\tA2$D\u0001\u001a\u0015\tQ\"\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QDD\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0002EA\u0006Ue\u00064XM]:bE2,'BA\u000f\u000f!\t\u00113%D\u0001\u0003\u0013\t!#AA\u0007IK\u0006dG\u000f[\"iK\u000e\\WM\u001d\u0005\tM\u0001\u0011\t\u0011)A\u0005+\u0005y\u0001.Z1mi\"\u001c\u0005.Z2lKJ\u001c\b\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0003*\u0003-\t7\r^8s'f\u001cH/Z7\u0016\u0003)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003=\nA!Y6lC&\u0011\u0011\u0007\f\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00054\u0001\t\u0005\t\u0015!\u0003+\u00031\t7\r^8s'f\u001cH/Z7!\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019a\u0014N\\5u}Q\u0019q\u0007O\u001d\u0011\u0005\t\u0002\u0001\"B\n5\u0001\u0004)\u0002\"\u0002\u00155\u0001\u0004Q\u0003bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u001aG\u0006t7-\u001a7mC\ndW\rS3bYRD7\t[3dW\u0016\u00148/F\u0001>!\rq\u0014IQ\u0007\u0002\u007f)\u0011\u0001ID\u0001\u000bG>dG.Z2uS>t\u0017BA\u0010@!\t\u00113)\u0003\u0002E\u0005\tA2)\u00198dK2d\u0017M\u00197f\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7.\u001a:\t\r\u0019\u0003\u0001\u0015!\u0003>\u0003i\u0019\u0017M\\2fY2\f'\r\\3IK\u0006dG\u000f[\"iK\u000e\\WM]:!\u0011\u0015A\u0005\u0001\"\u0001J\u0003-\u0019\u0007.Z2l\u0011\u0016\fG\u000e\u001e5\u0015\u0003)\u00032AF&N\u0013\ta\u0005EA\u0002TKF\u0004\"A\t(\n\u0005=\u0013!!\u0005%fC2$\bn\u00115fG.\u0014Vm];mi\")\u0011\u000b\u0001C\u0001%\u0006iqN^3sC2d7\u000b^1ukN$\"aU.\u0011\u0005Q;fB\u0001\u0012V\u0013\t1&!A\tIK\u0006dG\u000f[\"iK\u000e\\7\u000b^1ukNL!\u0001W-\u0003\u000bY\u000bG.^3\n\u0005is!aC#ok6,'/\u0019;j_:DQ\u0001\u0018)A\u0002)\u000b!\u0003[3bYRD7\t[3dWJ+7/\u001e7ug\")a\f\u0001C\u0001?\u0006!1\u000f^8q)\u0005\u0001\u0007CA\u0007b\u0013\t\u0011gB\u0001\u0003V]&$\b\"\u00023\u0001\t\u0013)\u0017AE2b]\u000e,G\u000e\\1cY\u0016\u001c\u0005.Z2lKJ$\"A\u00114\t\u000b\u001d\u001c\u0007\u0019A\u0011\u0002\u0003\r\u0004")
public class HealthCheckManager {
    private final Traversable<HealthChecker> healthCheckers;
    private final ActorSystem actorSystem;
    private final Traversable<CancellableHealthChecker> cancellableHealthCheckers;

    private Traversable<HealthChecker> healthCheckers() {
        return this.healthCheckers;
    }

    private ActorSystem actorSystem() {
        return this.actorSystem;
    }

    private Traversable<CancellableHealthChecker> cancellableHealthCheckers() {
        return this.cancellableHealthCheckers;
    }

    public Seq<HealthCheckResult> checkHealth() {
        return (Seq)((TraversableOnce)this.cancellableHealthCheckers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HealthCheckResult apply(CancellableHealthChecker healthChecker) {
                HealthCheckResult healthCheckResult;
                Option<HealthCheckResult> option = healthChecker.lastValue();
                if (option instanceof Some) {
                    HealthCheckResult status;
                    Some some = (Some)option;
                    healthCheckResult = status = (HealthCheckResult)some.x();
                } else {
                    healthCheckResult = new HealthCheckResult(HealthCheckStatus$.MODULE$.Unknown(), healthChecker, healthChecker.description(), (Option<Object>)None$.MODULE$, "-", (Option<Throwable>)None$.MODULE$, (Option<DateTime>)None$.MODULE$, (Option<Duration>)None$.MODULE$);
                }
                return healthCheckResult;
            }
        }, Traversable$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(HealthCheckResult result) {
                return result.status();
            }
        }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
    }

    public Enumeration.Value overallStatus(Seq<HealthCheckResult> healthCheckResults) {
        Option option = healthCheckResults.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HealthCheckResult h) {
                Enumeration.Value value = h.status();
                Enumeration.Value value2 = HealthCheckStatus$.MODULE$.Error();
                return !(value != null ? !value.equals(value2) : value2 != null) && h.checker().isCritical();
            }
        });
        Enumeration.Value value = option instanceof Some ? HealthCheckStatus$.MODULE$.Error() : HealthCheckStatus$.MODULE$.Ok();
        return value;
    }

    public void stop() {
        this.cancellableHealthCheckers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CancellableHealthChecker checker) {
                Logger$.MODULE$.debug((Function0)new Serializable(this, checker){
                    public static final long serialVersionUID = 0L;
                    private final CancellableHealthChecker checker$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Stopping checker [%s].")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checker$1}));
                    }
                    {
                        this.checker$1 = checker$1;
                    }
                });
                checker.cancel();
            }
        });
    }

    public CancellableHealthChecker au$com$agiledigital$healthchecker$HealthCheckManager$$cancellableChecker(HealthChecker c) {
        Cancellable cancellable = this.actorSystem().scheduler().schedule(new FiniteDuration(1L, TimeUnit.SECONDS), new FiniteDuration(c.frequency(), TimeUnit.MILLISECONDS), (Function0)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final HealthChecker c$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.c$1.checkAndUpdate();
            }
            {
                this.c$1 = c$1;
            }
        }, Execution.Implicits$.MODULE$.defaultContext());
        return new CancellableHealthChecker(c, cancellable);
    }

    public HealthCheckManager(Traversable<HealthChecker> healthCheckers, ActorSystem actorSystem) {
        this.healthCheckers = healthCheckers;
        this.actorSystem = actorSystem;
        this.cancellableHealthCheckers = (Traversable)healthCheckers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HealthCheckManager $outer;

            public final CancellableHealthChecker apply(HealthChecker x$1) {
                return this.$outer.au$com$agiledigital$healthchecker$HealthCheckManager$$cancellableChecker(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Traversable$.MODULE$.canBuildFrom());
    }
}

