/*
 * Decompiled with CFR 0.152.
 */
package au.com.agiledigital.healthchecker;

import au.com.agiledigital.healthchecker.HealthCheckResult;
import au.com.agiledigital.healthchecker.HealthCheckStatus$;
import au.com.agiledigital.healthchecker.HealthChecker;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import play.api.Configuration;
import play.api.Logger$;
import play.api.inject.Injector;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114Q!\u0001\u0002\u0002\u0002-\u0011\u0011CQ1tK\"+\u0017\r\u001c;i\u0007\",7m[3s\u0015\t\u0019A!A\u0007iK\u0006dG\u000f[2iK\u000e\\WM\u001d\u0006\u0003\u000b\u0019\tA\"Y4jY\u0016$\u0017nZ5uC2T!a\u0002\u0005\u0002\u0007\r|WNC\u0001\n\u0003\t\tWo\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011Q\u0002S3bYRD7\t[3dW\u0016\u0014\b\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u000b\u00023A\u0011!$\b\b\u0003\u001bmI!\u0001\b\b\u0002\rA\u0013X\rZ3g\u0013\tqrD\u0001\u0004TiJLgn\u001a\u0006\u000399A\u0001\"\t\u0001\u0003\u0002\u0003\u0006I!G\u0001\rI\u0016\u001c8M]5qi&|g\u000e\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u000511m\u001c8gS\u001e,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\n1!\u00199j\u0015\u0005Q\u0013\u0001\u00029mCfL!\u0001L\u0014\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!q\u0003A!A!\u0002\u0013)\u0013aB2p]\u001aLw\r\t\u0005\ta\u0001\u0011)\u0019!C\u0001c\u0005IaM]3rk\u0016t7-_\u000b\u0002eA\u0011QbM\u0005\u0003i9\u0011A\u0001T8oO\"Aa\u0007\u0001B\u0001B\u0003%!'\u0001\u0006ge\u0016\fX/\u001a8ds\u0002B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!O\u0001\u000bSN\u001c%/\u001b;jG\u0006dW#\u0001\u001e\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\fSN\u001c%/\u001b;jG\u0006d\u0007\u0005\u0003\u0005A\u0001\t\u0015\r\u0011\"\u0001B\u0003!IgN[3di>\u0014X#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015;\u0013AB5oU\u0016\u001cG/\u0003\u0002H\t\nA\u0011J\u001c6fGR|'\u000f\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003C\u0003%IgN[3di>\u0014\b\u0005C\u0003L\u0001\u0011\u0005A*\u0001\u0004=S:LGO\u0010\u000b\u0007\u001b:{\u0005+\u0015*\u0011\u0005M\u0001\u0001\"B\fK\u0001\u0004I\u0002\"B\u0012K\u0001\u0004)\u0003\"\u0002\u0019K\u0001\u0004\u0011\u0004\"\u0002\u001dK\u0001\u0004Q\u0004\"\u0002!K\u0001\u0004\u0011\u0005b\u0002+\u0001\u0001\u0004%\t!V\u0001\nY\u0006\u001cHOV1mk\u0016,\u0012A\u0016\t\u0004\u001b]K\u0016B\u0001-\u000f\u0005\u0019y\u0005\u000f^5p]B\u00111CW\u0005\u00037\n\u0011\u0011\u0003S3bYRD7\t[3dWJ+7/\u001e7u\u0011\u001di\u0006\u00011A\u0005\u0002y\u000bQ\u0002\\1tiZ\u000bG.^3`I\u0015\fHCA0c!\ti\u0001-\u0003\u0002b\u001d\t!QK\\5u\u0011\u001d\u0019G,!AA\u0002Y\u000b1\u0001\u001f\u00132\u0011\u0019)\u0007\u0001)Q\u0005-\u0006QA.Y:u-\u0006dW/\u001a\u0011\t\u000b\u001d\u0004A\u0011\u00015\u0002\u001d\rDWmY6B]\u0012,\u0006\u000fZ1uKR\tq\fC\u0003k\u0001\u0019\u00051.A\u0004e_\u000eCWmY6\u0015\u0003e\u0003")
public abstract class BaseHealthChecker
implements HealthChecker {
    private final String description;
    private final Configuration config;
    private final long frequency;
    private final boolean isCritical;
    private final Injector injector;
    private Option<HealthCheckResult> lastValue;

    @Override
    public String description() {
        return this.description;
    }

    public Configuration config() {
        return this.config;
    }

    @Override
    public long frequency() {
        return this.frequency;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public Injector injector() {
        return this.injector;
    }

    @Override
    public Option<HealthCheckResult> lastValue() {
        return this.lastValue;
    }

    public void lastValue_$eq(Option<HealthCheckResult> x$1) {
        this.lastValue = x$1;
    }

    @Override
    public void checkAndUpdate() {
        Logger$.MODULE$.trace((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseHealthChecker $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Updating health checker [").append((Object)BoxesRunTime.boxToLong((long)this.$outer.frequency())).append((Object)"] [").append((Object)this.$outer.description()).append((Object)"].").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        long startTime = System.currentTimeMillis();
        Some date = new Some((Object)new DateTime());
        HealthCheckResult newResult = this.doCheck();
        long endTime = System.currentTimeMillis();
        Some x$1 = date;
        Some x$2 = new Some((Object)new Duration(endTime - startTime));
        Enumeration.Value x$3 = newResult.copy$default$1();
        HealthChecker x$4 = newResult.copy$default$2();
        String x$5 = newResult.copy$default$3();
        Option<Object> x$6 = newResult.copy$default$4();
        String x$7 = newResult.copy$default$5();
        Option<Throwable> x$8 = newResult.copy$default$6();
        this.lastValue_$eq((Option<HealthCheckResult>)new Some((Object)newResult.copy(x$3, x$4, x$5, x$6, x$7, x$8, (Option<DateTime>)x$1, (Option<Duration>)x$2)));
        Enumeration.Value value = newResult.status();
        Enumeration.Value value2 = HealthCheckStatus$.MODULE$.Error();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Logger$.MODULE$.error((Function0)new Serializable(this, newResult){
                public static final long serialVersionUID = 0L;
                private final HealthCheckResult newResult$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Health check failed [").append((Object)this.newResult$1).append((Object)"].").toString();
                }
                {
                    this.newResult$1 = newResult$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = HealthCheckStatus$.MODULE$.Warning();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Logger$.MODULE$.warn((Function0)new Serializable(this, newResult){
                    public static final long serialVersionUID = 0L;
                    private final HealthCheckResult newResult$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Health check warning [").append((Object)this.newResult$1).append((Object)"].").toString();
                    }
                    {
                        this.newResult$1 = newResult$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Logger$.MODULE$.trace((Function0)new Serializable(this, newResult){
                    public static final long serialVersionUID = 0L;
                    private final HealthCheckResult newResult$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Health check complete [").append((Object)this.newResult$1).append((Object)"].").toString();
                    }
                    {
                        this.newResult$1 = newResult$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public abstract HealthCheckResult doCheck();

    public BaseHealthChecker(String description, Configuration config, long frequency, boolean isCritical, Injector injector) {
        this.description = description;
        this.config = config;
        this.frequency = frequency;
        this.isCritical = isCritical;
        this.injector = injector;
        this.lastValue = None$.MODULE$;
    }
}

