/*
 * Decompiled with CFR 0.152.
 */
package kamon.graphite;

import com.typesafe.config.Config;
import kamon.graphite.SimpleMetricKeyGenerator;
import kamon.metric.CounterKey;
import kamon.metric.Entity;
import kamon.metric.GaugeKey;
import kamon.metric.HistogramKey;
import kamon.metric.MetricKey;
import kamon.metric.MinMaxCounterKey;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u000f\tQRi]2ba&tw-T3ue&\u001c7*Z=HK:,'/\u0019;pe*\u00111\u0001B\u0001\tOJ\f\u0007\u000f[5uK*\tQ!A\u0003lC6|gn\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019\u0016.\u001c9mK6+GO]5d\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u001d\u000511m\u001c8gS\u001e\u0004\"aD\u000b\u000e\u0003AQ!!D\t\u000b\u0005I\u0019\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003Q\t1aY8n\u0013\t1\u0002C\u0001\u0004D_:4\u0017n\u001a\u0005\u00061\u0001!\t!G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005iY\u0002CA\u0005\u0001\u0011\u0015iq\u00031\u0001\u000f\u0011\u0015i\u0002\u0001\"\u0011\u001f\u0003A\u0019'/Z1uK:{'/\\1mSj,'\u000f\u0006\u0002 GA\u0011\u0001%I\u0007\u0002\u0001%\u0011!E\u0003\u0002\u000b\u001d>\u0014X.\u00197ju\u0016\u0014\b\"\u0002\u0013\u001d\u0001\u0004)\u0013\u0001C:ue\u0006$XmZ=\u0011\u0005\u0019zcBA\u0014.!\tA3&D\u0001*\u0015\tQc!\u0001\u0004=e>|GO\u0010\u0006\u0002Y\u0005)1oY1mC&\u0011afK\u0001\u0007!J,G-\u001a4\n\u0005A\n$AB*ue&twM\u0003\u0002/W!)1\u0007\u0001C!i\u0005Yq-\u001a8fe\u0006$XmS3z)\r)S'\u0010\u0005\u0006mI\u0002\raN\u0001\u0007K:$\u0018\u000e^=\u0011\u0005aZT\"A\u001d\u000b\u0005i\"\u0011AB7fiJL7-\u0003\u0002=s\t1QI\u001c;jifDQA\u0010\u001aA\u0002}\n\u0011\"\\3ue&\u001c7*Z=\u0011\u0005a\u0002\u0015BA!:\u0005%iU\r\u001e:jG.+\u0017\u0010")
public class EscapingMetricKeyGenerator
extends SimpleMetricKeyGenerator {
    @Override
    public Function1<String, String> createNormalizer(String strategy) {
        return (Function1 & java.io.Serializable & Serializable)s -> s.replace(": ", "-").replace(" ", "_").replace("/", "_").replaceAll("^\\.", "_").replaceAll("([^\\\\])\\.", "$1_").replace("\\.", ".");
    }

    @Override
    public String generateKey(Entity entity, MetricKey metricKey) {
        String string;
        String base = super.generateKey(entity, metricKey);
        MetricKey metricKey2 = metricKey;
        if (metricKey2 instanceof HistogramKey) {
            string = "timers";
        } else if (metricKey2 instanceof CounterKey) {
            string = "counters";
        } else if (metricKey2 instanceof GaugeKey) {
            string = "gauges";
        } else if (metricKey2 instanceof MinMaxCounterKey) {
            string = "counters";
        } else {
            throw new MatchError((Object)metricKey2);
        }
        String metricPrefix = string;
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stats.", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricPrefix, base}));
    }

    public EscapingMetricKeyGenerator(Config config) {
        super(config);
    }
}

